<div class="entry-utility">

<?php if( is_single() ): ?>

	<?php plug_shop_posted_in(); ?>
	<?php edit_post_link( esc_html__( 'Edit', 'plug-shop' ), '<span class="edit-link">', '</span>' ); ?>

<?php else: ?>

	<?php if ( count( get_the_category() ) ) : ?>
		<span class="cat-links">
			<?php printf( '<span class="%1$s">%2$s</span> <i class="icon-ios-folder-outline"></i> %3$s',
				'entry-utility-prep entry-utility-prep-cat-links',
					esc_html__('Posted in', 'plug-shop'),
				get_the_category_list( ', ' ) 
			); ?>
		</span>
		<span class="meta-sep">|</span>
	<?php endif; ?>
	<?php
		$tags_list = get_the_tag_list( '', ', ' );

		if ( $tags_list ):
	?>
		<span class="tag-links">
			<?php printf(
				'<span class="%1$s">%2$s</span> <i class="icon-tag-outline"></i> %3$s',
				'entry-utility-prep entry-utility-prep-tag-links',
				esc_html__( 'Tagged', 'plug-shop' ),
				wp_kses($tags_list, array(
					'a' => array(
						'href' => true,
						'rel'  => true
					)
				) )
			);
			?>
		</span>
		<span class="meta-sep">|</span>
	<?php endif; ?>
	<span class="comments-link"><i class="icon-chat-talk-outline"></i> <?php comments_popup_link( esc_html__( 'Leave a comment', 'plug-shop' ), esc_html__( '1 Comment', 'plug-shop' ), esc_html__( '% Comments', 'plug-shop' ) ); ?></span>
	<?php edit_post_link( esc_html__( 'Edit', 'plug-shop' ), '<span class="meta-sep">|</span> <span class="edit-link">', '</span>' ); ?>

<?php endif; ?>

</div><!-- .entry-utility -->