<?php
/**
 * The loop that displays dynamic post type.
 *
 * The loop displays the custom posts and the custom post content.  See
 * http://codex.wordpress.org/The_Loop to understand it and
 * http://codex.wordpress.org/Template_Tags to understand
 * the tags used in it.
 *
 * This can be overridden in child themes with loop.php or
 * loop-template.php, where 'template' is the loop context
 * requested by a template. For example, loop-index.php would
 * be used if it exists and we ask for the loop with:
 * <code>get_template_part( 'loop', 'index' );</code>
 *
 * @package Plug Shop WordPress Theme
 * @subpackage Plug Shop
 * @author Pressfore - www.pressfore.com
 */
?>

<?php  
	
	$args = plug_shop_dynamic_post_args();
	$dynamic_query = new WP_Query($args);

	# Pass our custom query to be globally accessible
	$GLOBALS['plug_shop_query'] = $dynamic_query;

?>

<?php /* If there are no posts to display, such as an empty archive page */ ?>
<?php if ( ! $dynamic_query->have_posts() ) : ?>
	<div id="post-0" class="post error404 not-found">
		<h1 class="entry-title"><?php esc_html_e( 'Not Found', 'plug-shop' ); ?></h1>
		<div class="entry-content">
			<p><?php esc_html_e( 'Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.', 'plug-shop' ); ?></p>
			<?php get_search_form(); ?>
		</div><!-- .entry-content -->
	</div><!-- #post-0 -->
<?php endif; ?>

<?php while ( $dynamic_query->have_posts() ) : $dynamic_query->the_post(); ?>

		<?php 
			/**
			* Main hook that will add post markup
			*
			*/
			do_action( 'plug_shop_post_list_markup' );
		?>

<?php

	endwhile; // End the loop. 
	wp_reset_postdata();
?>
