<?php
/**
 *
 * Enabling support for WooCommerce
 *
 * @package Plug Shop
 */

// File Security Check
if ( ! empty( $_SERVER['SCRIPT_FILENAME'] ) && basename( __FILE__ ) == basename( $_SERVER['SCRIPT_FILENAME'] ) ) {
    die ( 'You do not have sufficient permissions to access this page' );
}
?>
<?php

add_action( 'after_setup_theme', 'plug_shop_woocommerce_support' );
function plug_shop_woocommerce_support() {
	add_theme_support( 'woocommerce' );
}

// remove single product default wrapper.
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );

// remove breadcrumbs.
remove_action( 'woocommerce_before_main_content','woocommerce_breadcrumb', 20, 0 );

// Remove pages title
add_filter( 'woocommerce_show_page_title', '__return_false' );

/********************************************************************
 *  Product list Oriented Styles
 */

// Wrap rating with custom HTML container
add_action( 'woocommerce_after_shop_loop_item_title', 'plug_shop_before_rating_open_tag', 4 );
add_action( 'woocommerce_after_shop_loop_item_title', 'plug_shop_after_rating_close_tag', 6 );

// Wrap loop title with our custom HTML container
add_action( 'woocommerce_shop_loop_item_title', 'plug_shop_before_loop_title_open_tag', 8 );
add_action( 'woocommerce_shop_loop_item_title', 'plug_shop_after_loop_title_close_tag', 11 );

//Override product title with our own html
remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
add_action('woocommerce_shop_loop_item_title', 'plug_shop_loop_product_title', 10 );

// Remove default wc link around elements
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );

// Add wc link around thumbnails
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_open', 9 );
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 11 );

//Move Add to cart button
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
add_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_add_to_cart', 9 );

// Add column layout to shop.
add_filter( 'body_class', 'plug_shop_shop_layout');

// Limit the number of products per page.
add_filter( 'loop_shop_per_page', 'plug_shop_loop_per_page_limit', 20 );


/********************************************************************
 *  Product Single Oriented Styles
 */

// Add single product wrapper.
add_action( 'woocommerce_before_main_content', 'plug_shop_content_wrap', 1 );
add_action( 'woocommerce_before_main_content', 'plug_shop_add_banners_on_shop', 1 );
add_action( 'woocommerce_after_main_content', 'plug_shop_content_wrap_close', 1 );

// Remove woocommerce page and single product title on single template and add custom text.
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
add_action('woocommerce_single_product_summary', 'plug_shop_wc_remove_title', 5);

//Override product thumbnaiil columns size
add_filter('woocommerce_product_thumbnails_columns', 'plug_shop_thumbnail_columns');

// Move the product meta above the add to cart
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 25);


if ( ! function_exists( 'plug_shop_loop_per_page_limit' ) ) {
	/**
	 * Limit the products per page on shop pages
	 * @return int
	 * @since  1.0.0
	 */
	function plug_shop_loop_per_page_limit($cols) {
		return 12;
	}
}

if ( ! function_exists( 'plug_shop_wc_remove_title' ) ) {
	/**
	 * Remove woocommerce page title
	 * @return string
	 * @since  1.0.0
	 */
	function plug_shop_wc_remove_title() {
		return printf('<h6 class="psf-big-heading psf-product-info">%s</h6>', esc_html__('Product Info', 'plug-shop') );
	}
}

if ( ! function_exists( 'plug_shop_thumbnail_columns' ) ) {
	/**
	 * Product gallery thumnail columns
	 *
	 * @return integer number of columns
	 * @since  1.0.0
	 */
	function plug_shop_thumbnail_columns()
	{
		return 3;//intval(apply_filters( 'plug_shop_product_thumbnail_columns', 3) );
	}
}

if ( ! function_exists( 'plug_shop_add_banners_on_shop' ) ) {
	/**
	 * Add banners to the shop page, before other content
	 */
	function plug_shop_add_banners_on_shop() {
		echo plug_shop_get_banners();
	}
}

if ( ! function_exists( 'plug_shop_shop_layout' ) ) {
	/**
	 * Shop Layout
	 *
	 * Check for product column number
	 * and apply the proper class to the shop
	 *
	 * @param $classes
	 * @return array
	 */
	function plug_shop_shop_layout( $classes ) {
		$columns = plug_shop_options( 'shop_columns' ,'column-4' );

		if ( plug_shop_is_wc_installed() && is_shop() ) {
			$classes[] = 'shop';
			$classes[] = esc_attr( $columns );
		}

		return $classes;
	}
}

if ( ! function_exists( 'plug_shop_before_loop_title_open_tag' ) ) {
	/**
	 * Opening tag for loop title on product list
	 *
	 * @return void
	 */
	function plug_shop_before_loop_title_open_tag() {
		?>
			<div class="plug-shop-title-wrap">
		<?php
	}
}

if ( ! function_exists( 'plug_shop_after_loop_title_close_tag' ) ) {
	/**
	 * Closing tag for loop title on product list
	 *
	 * @return void
	 */
	function plug_shop_after_loop_title_close_tag() {
		?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'plug_shop_before_rating_open_tag' ) ) {
	/**
	 * Opening tag for rating on product list
	 *
	 * @return void
	 */
	function plug_shop_before_rating_open_tag() {
		?>
			<div class="plug-shop-rating-wrap">
		<?php
	}
}

if ( ! function_exists( 'plug_shop_after_rating_close_tag' ) ) {
	/**
	 * Closing tag for rating on product list
	 *
	 * @return void
	 */
	function plug_shop_after_rating_close_tag() {
		?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'plug_shop_loop_product_title' ) ) {
	/**
	 * Replace the loop title output with our custom HTML
	 *
	 * @return void
	 */
	function plug_shop_loop_product_title() {
		printf( '<h4 class="plug-shop-loop-title">%s</h4>', get_the_title() );
	}
}

if ( ! function_exists( 'plug_shop_cart_link_fragment' ) ) {
	/**
	 * Cart Fragments
	 * Ensure cart contents update when products are added to the cart via AJAX
	 *
	 * @param  array $fragments Fragments to refresh via AJAX.
	 * @return array            Fragments to refresh via AJAX
	 */
	function plug_shop_cart_link_fragment( $fragments ) {
		global $woocommerce;

		ob_start();
		plug_shop_cart_link();
		$fragments['a.cart-contents'] = ob_get_clean();

		return $fragments;
	}
}

add_filter( 'add_to_cart_fragments', 'plug_shop_cart_link_fragment' );

