<?php
/**
 * Plug Shop Pro Tab on a welcome screen.
 *
 * @package Plug Shop.
 */

?>

<div id="pro" class="tp-tab-content tp-pro-tab card">

<h2 class="tab-heading"><?php esc_html_e('Plug Shop Pro Addon', 'plug-shop'); ?></h2>

<div class="tp-two-col">
	<div class="tp-col">
		<h3><?php esc_html_e( 'Woocommerce Dropdown Cart', 'plug-shop' ); ?></h3>
		<p><?php esc_html_e( 'Plug Shop Pro Addon integrates woocommerce shopping cart, which can be added to header as custom widget.', 'plug-shop' ); ?></p>
	</div>
	<div class="tp-col">
		<h3><?php esc_html_e( 'Megamenu', 'plug-shop' ); ?></h3>
		<p><?php esc_html_e( 'With Plug Shop Pro Addon, you will get wide menu which can enrich your website.', 'plug-shop' ); ?></p>
	</div>
</div>

<div class="tp-two-col">
	<div class="tp-col">
		<h3><?php esc_html_e( 'Uncovering Footer', 'plug-shop' ); ?></h3>
		<p><?php esc_html_e( 'Plug Shop Pro Addon Also adds uncovering footer option.', 'plug-shop' ); ?></p>
	</div>
	<div class="tp-col">
		<h3><?php esc_html_e( 'Custom Widgets', 'plug-shop' ); ?></h3>
		<p><?php esc_html_e( 'With Plug Shop Pro Addon, you will have few custom made widgets, including the woocommerce dropdown cart', 'plug-shop' ); ?></p>
	</div>
</div>

<div class="tp-two-col">
	<div class="tp-col">
		<h3><?php esc_html_e( 'Blog Masonry Layout', 'plug-shop' ); ?></h3>
		<p><?php esc_html_e( 'If you do not like standard blog layout you can upgrade to pro and get the Masonry layout for blog.', 'plug-shop' ); ?></p>
	</div>
	<div class="tp-col">
		<h3><?php esc_html_e( 'Dynamic Posts List', 'plug-shop' ); ?></h3>
		<p><?php esc_html_e( 'Dynamic page template will be able to display any custom post type that is registered on your website. Meaning you can list any post type (like some 3rd party portfolio) in the same layout as current blog (Standard, masonry).', 'plug-shop' ); ?></p>
	</div>
</div>
<div class="tp-two-col">
	<div class="tp-col">
		<h3><?php esc_html_e( 'XML Demo Data', 'plug-shop' ); ?></h3>
		<p><?php esc_html_e( 'Plug Shop Pro Addon also comes packed with the whole demo data, which includes all sub pages you see on demo, so you can import it and start editing..', 'plug-shop' ); ?></p>
	</div>
	<div class="tp-col">
		<h3><?php esc_html_e( 'Options', 'plug-shop' ); ?></h3>
		<p><?php esc_html_e( 'Plug Shop Pro also extends already rich options giving you more control over the layout.', 'plug-shop' ); ?></p>
	</div>
</div>
<div class="tp-well">
	<div class="tp-well-message"><?php esc_html_e( 'Plug Shop Pro also comes with a year of updates and our friendly support.', 'plug-shop' ); ?></div>
	<p>
		<?php
			printf(
				'<a href="%s" target="_blank" class="button button-hero button-primary">%s</a>',
				esc_url( 'http://pressfore.com/item/plug-shop-pro/' ),
				esc_html__( 'Purchase Plug Shop Pro', 'plug-shop' )
			);
		?>
	</p>
</div>

</div>
