<?php
/**
 * Intro Tab on a welcome screen.
 *
 * @package Plug Shop.
 */

?>

<div id="features" class="tp-tab-content card">

<h2 class="tab-heading"><?php esc_html_e( 'Theme Features', 'plug-shop' ); ?></h2>

<div class="tp-two-col">
	<div class="tp-col">
		<div class="tp-media-container" style="margin-top: 0;">
			<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/welcome-screen/img/pf-theme-feature-01.jpg' ); ?>">
		</div>
	</div>
	<div class="tp-col">
		<h3 class="tp-col-heading" style="margin-top: 0;"><?php esc_html_e( 'WooCommerce Ready', 'plug-shop' ); ?></h3>
		<p><?php esc_html_e( 'Support for WooCommerce plugin is present, and with some nice features. You can choose between 3 and 4 columns layouts, show slider on all pages or just homepage and there are also shop templates with and without sidebar.', 'plug-shop' ); ?></p>
	</div>
</div>

<hr>

<div class="tp-two-col">
	<div class="tp-col">
		<div class="tp-media-container">
			<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/welcome-screen/img/pf-theme-feature-02.jpg' ); ?>">
		</div>
	</div>
	<div class="tp-col">
		<h3 class="tp-col-heading"><?php esc_html_e( 'Responsive!', 'plug-shop' ); ?></h3>
		<p><?php esc_html_e( 'Theme playing fair with all devices. Responsive Layout is built to work great on any device from a small handheld devices to large desktops and retina screens.', 'plug-shop' ); ?></p>
	</div>
</div>

<hr>

<div class="tp-two-col">
	<div class="tp-col">
		<div class="tp-media-container">
			<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/welcome-screen/img/pf-theme-feature-03.jpg' ); ?>">
		</div>
	</div>
	<div class="tp-col">
		<h3 class="tp-col-heading"><?php esc_html_e( 'Rolo Slider', 'plug-shop' ); ?></h3>
		<p><?php esc_html_e( 'Our popular Rolo Slider plugin is included, and you can configure it easily for only home page or it can be present on all pages. Also, with its powerful extensions you can even showcase product automatically.', 'plug-shop' ); ?></p>
	</div>
</div>

<hr>

<div class="tp-two-col">
	<div class="tp-col">
		<div class="tp-media-container">
			<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/welcome-screen/img/pf-theme-feature-04.jpg' ); ?>">
		</div>
	</div>
	<div class="tp-col">
		<h3 class="tp-col-heading"><?php esc_html_e( 'Shop Banners', 'plug-shop' ); ?></h3>
		<p><?php esc_html_e( 'Theme offers option for setting up to two banners on shop page to showcase products or maybe use them as ads, and they can be set only on shop, on all WooCommerce pages or on all pages except single products.', 'plug-shop' ); ?></p>
	</div>
</div>

<hr>

<div class="tp-two-col">
	<div class="tp-col">
		<div class="tp-media-container">
			<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/welcome-screen/img/pf-theme-feature-05.jpg' ); ?>">
		</div>
	</div>
	<div class="tp-col">
		<h3 class="tp-col-heading"><?php esc_html_e( 'Colorful options', 'plug-shop' ); ?></h3>
		<p><?php esc_html_e( 'With powerful theme customizer, you can easily change the look and feel of your website by adjusting the color scheme. You can change header, body, and both footer top and footer bottom colors.', 'plug-shop' ); ?></p>

	</div>
</div>

<hr>

<div class="tp-two-col">
	<div class="tp-col">
		<div class="tp-media-container">
			<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/welcome-screen/img/pf-theme-feature-06.jpg' ); ?>">
		</div>
	</div>
	<div class="tp-col">
		<h3 class="tp-col-heading"><?php esc_html_e( 'Rich Typography', 'plug-shop' ); ?></h3>
		<p><?php esc_html_e( 'With 600+ Google fonts, and customizable sizes for all text elements, this robust integration offer a complete solution for a using different font families for all users needs.', 'plug-shop' ); ?></p>
	</div>
</div>

<hr>

<div class="tp-two-col">
	<div class="tp-col">
		<div class="tp-media-container">
			<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/welcome-screen/img/pf-theme-feature-07.jpg' ); ?>">
		</div>
	</div>
	<div class="tp-col">
		<h3 class="tp-col-heading"><?php esc_html_e( 'High coding standards!', 'plug-shop' ); ?></h3>
		<p><?php esc_html_e( 'With each theme we follow WordPress coding standards and provides multiple hooks and template overrides from child themes. Building a completely different theme, or just disabling some options and features from parent theme can be done easily.', 'plug-shop' ); ?></p>
	</div>
</div>

</div>
