<?php
/**
 * Theme Customizer
 * 
 *
 *
 * @package WordPress
 * @subpackage Plug Shop
 * @since 1.0.0
 *
 */

# Extras

Plug_Shop_Kirki::add_section( 'plug_shop_extras', array(
	'title'       => esc_html__( 'Extras', 'plug-shop' ),
	'priority'    => 50,
	'description' => esc_html__('Use the fields below to add some simple text (such as a phone number or copyright) to the header and footer areas.', 'plug-shop' ),
    'capability'  => 'edit_theme_options',
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings' => 'plug_shop_options[footer_extras]',
	'label'    => esc_html__('Footer Extras Text', 'plug-shop'),
	'section'  => 'plug_shop_extras',
	'type'     => 'textarea',
	'default'  => sprintf(
		'%s <a href="%s" title="%s">%s</a>',
		esc_html__( 'Lovely WordPress Theme developed by', 'plug-shop' ),
		esc_url( 'http://www.pressfore.com' ),
		esc_attr__( 'Pressfore WordPress Themes', 'plug-shop' ),
		esc_html__( 'Pressfore', 'plug-shop' )
	),
	'sanitize_callback' => 'wp_filter_post_kses',
	'transport' => 'postMessage',
	'js_vars' => array(
		array(
			'element'  => '#credits',
			'function' => 'html'
		),
	),
) );