<?php
/**
 * Theme Customizer
 * 
 *
 *
 * @package WordPress
 * @subpackage Plug Shop
 * @since 1.0.0
 *
 */

# Woocommerce

if( class_exists( 'woocommerce' ) )
{

	Plug_Shop_Kirki::add_section( 'plug_shop_woo', array(
		'title'       => esc_html__('Woocommerce', 'plug-shop' ),
		'priority'    => 45,
		'description' => esc_html__('Woocommerce related options', 'plug-shop'),
	    'capability'  => 'edit_theme_options',
	) );


	Plug_Shop_Kirki::add_field( 'plug_shop', array(
		'settings'    => 'plug_shop_options[prod_bg_thumb]',
		'label'       => esc_html__( 'Use Product Featured Image as Title Background:', 'plug-shop' ),
		'description' => esc_html__( 'You can use featured image of products to be displayed as title background image, just like for pages.', 'plug-shop' ),
		'section'     => 'plug_shop_woo',
		'type'        => 'select',
		'choices'     => array(
			'yes'     => esc_html__( 'Yes', 'plug-shop' ),
			'no'      => esc_html__( 'No', 'plug-shop' )
	    ),
		'default'    => 'no',
	) );

	Plug_Shop_Kirki::add_field( 'plug_shop', array(
		'settings'    => 'plug_shop_options[shop_columns]',
		'label'       => esc_html__( 'Shop - Product List Columns', 'plug-shop' ),
		'description' => esc_html__( 'You can choose the number of columns in which products on the shop page will be listed.', 'plug-shop' ),
		'section'     => 'plug_shop_woo',
		'type'        => 'select',
		'choices'     => array(
			'column-4'  => esc_html__( '4 Columns', 'plug-shop' ),
			'column-3'  => esc_html__( '3 Columns', 'plug-shop' )
	    ),
		'default'    => 'column-5',
	) );

	Plug_Shop_Kirki::add_field( 'plug_shop', array(
			'settings'    => 'plug_shop_options[shop_layout]',
			'label'       => esc_html__( 'Shop Pages Layout', 'plug-shop' ),
			'section'     => 'plug_shop_woo',
			'type'        => 'select',
			'choices'     => array(
					'sidebar'     => esc_html__( 'With Sidebar', 'plug-shop' ),
					'full'        => esc_html__( 'Full Width', 'plug-shop' )
			),
			'default'    => 'no',
	) );
}
