<?php
/**
 * Theme Customizer
 * 
 *
 *
 * @package WordPress
 * @subpackage Plug Shop
 * @since 1.0.0
 *
 */

# Typography

Plug_Shop_Kirki::add_section( 'plug_shop_fonts', array(
	'title'       => esc_html__( 'Typography', 'plug-shop' ),
	'priority'    => 40,
	'description' => esc_html__('Select Website Typography', 'plug-shop' ),
    'capability'  => 'edit_theme_options',
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'type'        => 'typography',
	'settings'    => 'plug_shop_options[header_font]',
	'label'       => esc_html__( 'Header Font', 'plug-shop' ),
	'section'     => 'plug_shop_fonts',
	'default'     => array(
		'font-family'    => 'Libre Franklin',
		'variant'        => '400',
		'font-size'      => '14px',
		'letter-spacing' => '0',
		'subsets'        => array( 'latin-ext' ),
		'text-transform' => 'capitalize',
		'text-align'     => 'right'
	),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'type'        => 'typography',
	'settings'    => 'plug_shop_options[main_font]',
	'label'       => esc_html__( 'Main Font', 'plug-shop' ),
	'section'     => 'plug_shop_fonts',
	'default'     => array(
		'font-family'    => 'Raleway',
		'variant'        => 'regular',
		'font-size'      => '14px',
		'line-height'    => '1.5',
		'letter-spacing' => '0',
		'subsets'        => array(),
	),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'type'        => 'typography',
	'settings'    => 'plug_shop_options[heading_font]',
	'label'       => esc_html__( 'Headings Font', 'plug-shop' ),
	'section'     => 'plug_shop_fonts',
	'default'     => array(
		'font-family'    => 'Roboto',
		'variant'        => 'regular',
		'subsets'        => array(),
		'text-align'     => 'left'
	),
) );