<?php
/**
 * Theme Customizer
 *
 *
 *
 * @package WordPress
 * @subpackage Plug Shop
 * @since 1.0.0
 *
 */


# Colors

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings' => 'plug_shop_options[primary_color]',
	'label'    => esc_html__('Primary Brand Color', 'plug-shop'),
	'section'  => 'colors',
	'type'     => 'color',
	'default'  => '#40c4ff',
	'choices'     => array(
			'alpha' => true,
	),
	'transport' => 'postMessage',
	'js_vars' => array(
		array(
			'element'  => 'a#site-title, .nav-collapse b, .woocommerce-Price-amount, .widget-container.widget_products ul.product_list_widget li .amount, .widget-container.widget_recently_viewed_products ul.product_list_widget li .amount, .widget-container.widget_top_rated_products ul.product_list_widget li .amount, .widget.widget_products ul.product_list_widget li .amount, .widget.widget_recently_viewed_products ul.product_list_widget li .amount, .widget.widget_top_rated_products ul.product_list_widget li .amount, .woocommerce ul.products li.product .plug-shop-title-wrap .button, .woocommerce-message::before, .entry-header #breadcrumbs a:not(:last-child)::after, .entry-header #breadcrumbs span:not(:last-child)::after, .woocommerce ul.products li.product .plug-shop-title-wrap .button, .woocommerce-message::before, .entry-header #breadcrumbs a:not(:last-child)::after, .entry-header #breadcrumbs span:not(:last-child)::after',
			'function' => 'css',
			'property' => 'color'
		),
		array(
			'element'  => '.woocommerce-message, .main-navigation .menu .sub-menu',
			'function' => 'css',
			'property' => 'border-top-color'
		),
		array(
			'element'  => '.comment-form .form-submit input[type="submit"], .woocommerce.widget_price_filter .ui-slider .ui-slider-range, .woocommerce.widget_price_filter .ui-slider .ui-slider-handle, .woocommerce.widget_price_filter .price_slider_amount .button, .woocommerce-cart .woocommerce #payment div.payment_box, .woocommerce-page .woocommerce #payment div.payment_box, .woocommerce #respond input#submit.alt, .woocommerce #review_form #respond .form-submit input, .woocommerce .added_to_cart.wc-forward, .woocommerce .button, .woocommerce .button.wc-forward, .woocommerce a.button, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button, .woocommerce input.button.alt, .woocommerce.widget_price_filter .ui-slider .ui-slider-range, .woocommerce.widget_price_filter .ui-slider .ui-slider-handle, .woocommerce.widget_price_filter .price_slider_amount .button, .woocommerce-cart .woocommerce #payment div.payment_box, .woocommerce-page .woocommerce #payment div.payment_box',
			'function' => 'css',
			'property' => 'background-color'
		),
		array(
			'element'  => '.header-area .plug-shop-cart .widget_shopping_cart_content > p.buttons > a.button.wc-forward',
			'function' => 'css',
			'property' => 'border-color'
		)
	),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings' => 'plug_shop_options[secondary_color]',
	'label'    => esc_html__('Secondary Brand Color', 'plug-shop'),
	'section'  => 'colors',
	'type'     => 'color',
	'default'  => '',
	'choices'     => array(
			'alpha' => true,
	),
	'transport' => 'postMessage',
	'js_vars' => array(
		array(
			'element'  => 'span.site-desc',
			'function' => 'css',
			'property' => 'color'
		),
	),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings' => 'plug_shop_options[body_text_color]',
	'label'    => esc_html__('Body Text Color', 'plug-shop'),
	'section'  => 'colors',
	'type'     => 'color',
	'default'  => '#949393',
	'choices'     => array(
			'alpha' => true,
	),
	'transport' => 'postMessage',
	'js_vars' => array(
		array(
			'element'  => 'body',
			'function' => 'css',
			'property' => 'color'
		),
	),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings'  => 'plug_shop_options[heading_color]',
	'label'     => esc_html__('Headings Color', 'plug-shop'),
	'section'   => 'colors',
	'type'      => 'color',
	'default'   => '#545454',
	'choices'     => array(
			'alpha' => true,
	),
	'transport' => 'postMessage',
	'js_vars'   => array(
		array(
			'element'  => 'h1,h2,h3,h4,h5,h6',
			'function' => 'css',
			'property' => 'color'
		),
	),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings' => 'plug_shop_options[link_color]',
	'label'    => esc_html__('Link Color', 'plug-shop'),
	'section'  => 'colors',
	'type'     => 'color',
	'default'  => '#464646',
	'choices'     => array(
		'alpha' => true,
	),
	'transport' => 'postMessage',
	'js_vars' => array(
		array(
			'element'  => 'a, a:visited, #sidebar a',
			'function' => 'css',
			'property' => 'color'
		),
	),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings' => 'plug_shop_options[link_hover_color]',
	'label'    => esc_html__('Link Hover Color', 'plug-shop'),
	'section'  => 'colors',
	'type'     => 'color',
	'default'  => '#40c4ff',
	'choices'     => array(
			'alpha' => true,
	),
	'transport' => 'postMessage',
	'js_vars' => array(
		array(
			'element'  => 'a:hover, #sidebar a:hover',
			'function' => 'css',
			'property' => 'color'
		)
	),
) );