<?php
/**
 * Theme Customizer
 * 
 *
 *
 * @package WordPress
 * @subpackage Plug Shop
 * @since 1.0.0
 *
 */

# Layout Preferences

Plug_Shop_Kirki::add_section( 'plug_shop_layout', array(
	'title'       => esc_html__( 'Layout Preferences', 'plug-shop' ),
	'priority'    => 35,
	'description' => esc_html__('Layout related options', 'plug-shop'),
    'capability'  => 'edit_theme_options',
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings' => 'plug_shop_options[layout]',
	'label'    => esc_html__( 'Website Layout', 'plug-shop' ),
	'section'  => 'plug_shop_layout',
	'type'     => 'radio',
	'choices'  => array(
		'1200' => esc_html__('1200px', 'plug-shop'),
		'full' => esc_html__('Full Width', 'plug-shop')
	),
	'default'   => '1200',
	'priority'  => 5
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings' => 'plug_shop_options[sidebar_width]',
	'label'    => 'Sidebar Width:',
	'section'  => 'plug_shop_layout',
	'type'     => 'select',
	'choices'  => array(
		'2'   => esc_html__('2 Columns', 'plug-shop'),
		'3'   => esc_html__('3 Columns', 'plug-shop'),
		'4'   => esc_html__('4 Columns', 'plug-shop'),
    ),
	'default'    => '3',
	'priority'   => 10
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings' => 'plug_shop_options[sidebar_position]',
	'label'    => esc_html__('Sidebar Position:', 'plug-shop'),
	'section'  => 'plug_shop_layout',
	'type'     => 'select',
	'choices'  => array(
		'left'  => esc_html__('Left', 'plug-shop'),
		'right' => esc_html__('Right', 'plug-shop')
    ),
	'default'    => 'right',
	'priority'   => 20
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings'    => 'plug_shop_options[post_layout]',
    'label'       => esc_html__( 'Post Layout', 'plug-shop' ),
	'description' => esc_html__('Set the post layout - choose to display small featured image, or full size featured image.', 'plug-shop'),
	'section'     => 'plug_shop_layout',
	'type'        => 'radio-image',
	'choices'     => array(
        'layout-1' => get_template_directory_uri().'/assets/images/layout-1.jpg',
        'layout-2' => get_template_directory_uri().'/assets/images/layout-2.jpg'
    ),
	'default'    => 'layout-2',
	'priority'   => 25
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings'    => 'plug_shop_options[bg_thumb]',
	'label'       => esc_html__('Use Featured Image as Title Background:', 'plug-shop' ),
	'description' => esc_html__('You can use featured image of posts to be displayed as title background image, just like for pages.', 'plug-shop'),
	'section'     => 'plug_shop_layout',
	'type'        => 'select',
	'choices'     => array(
		'yes'     => esc_html__('Yes', 'plug-shop' ),
		'no'      => esc_html__('No', 'plug-shop' )
    ),
	'default'    => 'no',
	'priority'   => 30
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings' => 'plug_shop_options[crop_thumb]',
	'label'    => 'Crop Blog List Thumbnails:',
	'description' => esc_html__('After you change this setting install regenerate thumbnails plugin to re-crop the existing thumbnail to match applied size.', 'plug-shop'),
	'section'  => 'plug_shop_layout',
	'type'     => 'select',
	'choices'  => array(
		'yes'  => esc_html__('Hard Crop', 'plug-shop' ),
		'no'   => esc_html__('Soft Crop', 'plug-shop' ),
		'full' => esc_html__('Do Not Crop', 'plug-shop' )
    ),
	'default'    => 'no',
	'priority'    => 35
) );