<?php
/**
 * Theme Customizer
 * 
 *
 *
 * @package WordPress
 * @subpackage Plug Shop
 * @since 1.0.0
 *
 */

# Footer

Plug_Shop_Kirki::add_section( 'plug_shop_footer', array(
	'title'       => esc_html__( 'Footer', 'plug-shop' ),
	'priority'    => 30,
	'description' => esc_html__( 'Footer Related Options', 'plug-shop' ),
    'capability'  => 'edit_theme_options',
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings'   => 'plug_shop_options[footer_bg_top]',
	'label'      => esc_html__( 'Footer Top Background Color', 'plug-shop' ),
	'section'    => 'plug_shop_footer',
	'type'       => 'color',
	'default'    => '#f5f5f5',
	'choices'     => array(
			'alpha' => true,
	),
	'transport'  => 'postMessage',
	'js_vars' => array(
		array(
			'element'  => '#footer',
			'function' => 'css',
			'property' => 'background-color',
		),
	),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings'   => 'plug_shop_options[footer_bg_bottom]',
	'label'      => esc_html__( 'Footer Bottom Background Color', 'plug-shop' ),
	'section'    => 'plug_shop_footer',
	'type'       => 'color',
	'default'    => '#202020',
	'choices'     => array(
			'alpha' => true,
	),
	'transport'  => 'postMessage',
	'js_vars' => array(
		array(
			'element'  => '#footer #credits',
			'function' => 'css',
			'property' => 'background-color',
		),
	),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings'   => 'plug_shop_options[footer_text_color]',
	'label'      => esc_html__( 'Footer Text Color', 'plug-shop' ),
	'section'    => 'plug_shop_footer',
	'type'       => 'color',
	'default'    => '#999',
	'choices'     => array(
			'alpha' => true,
	),
	'transport'  => 'postMessage',
	'js_vars' => array(
		array(
			'element'  => '#footer',
			'function' => 'css',
			'property' => 'color',
		),
	),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings'    => 'plug_shop_options[footer_btext_color]',
	'label'       => esc_html__( 'Footer Credits Text Color', 'plug-shop' ),
	'section'     => 'plug_shop_footer',
	'type'        => 'color',
	'default'     => '#eee',
	'choices'     => array(
			'alpha' => true,
	),
	'transport'   => 'postMessage',
	'js_vars' => array(
		array(
			'element'  => '#footer #credits',
			'function' => 'css',
			'property' => 'color',
		),
	),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings'  => 'plug_shop_options[footer_link_color]',
	'label'     => esc_html__( 'Footer Link Color', 'plug-shop' ),
	'section'   => 'plug_shop_footer',
	'type'      => 'color',
	'default'   => '#777',
	'choices'     => array(
			'alpha' => true,
	),
	'transport' => 'postMessage',
	'js_vars' => array(
		array(
			'element'  => '#footer a',
			'function' => 'css',
			'property' => 'color',
		),
	),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings'  => 'plug_shop_options[footer_link_hover_color]',
	'label'     => esc_html__( 'Footer Link Hover Color', 'plug-shop' ),
	'section'   => 'plug_shop_footer',
	'type'      => 'color',
	'default'   => '#40c4ff',
	'choices'     => array(
			'alpha' => true,
	),
	'transport' => 'postMessage',
	'js_vars' => array(
		array(
			'element'  => '#footer a:hover, #footer a:visited',
			'function' => 'css',
			'property' => 'color',
		),
	),
) );