<?php
/**
 * Theme Customizer
 * 
 *
 *
 * @package WordPress
 * @subpackage Plug Shop
 * @since 1.0.0
 *
 */

# Preloader

Plug_Shop_Kirki::add_section( 'plug_shop_content', array(
	'title'       => esc_html__( 'Shop Content', 'plug-shop' ),
	'priority'    => 18,
	'description' => esc_html__( 'Shop Content Options', 'plug-shop' ),
    'capability'  => 'edit_theme_options'
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'type'        => 'repeater',
	'settings'    => 'plug_shop_options[banners]',
	'label'       => esc_html__('Add Banners:', 'plug-shop'),
	'description' => esc_html__( 'Free version of the theme allows up to 2 banners. More than that will not be displayed if added.', 'plug-shop' ),
	'section'     => 'plug_shop_content',
	'row_label'   => array(
		'type'  => 'text',
		'value' => esc_attr__('Banner Image', 'plug-shop' ),
	),
	'fields' => array(
		'image' => array(
				'type'        => 'image',
				'label'       => esc_attr__( 'Image', 'plug-shop' ),
				'description' => esc_attr__( 'Upload the banner image', 'plug-shop' ),
		),
		'link_text' => array(
				'type'        => 'text',
				'label'       => esc_attr__( 'Button Text', 'plug-shop' ),
				'description' => esc_attr__( 'This will be the text for your banner button', 'plug-shop' ),
				'default'     => '',
		),
		'link_url' => array(
				'type'        => 'text',
				'label'       => esc_attr__( 'Banner URL', 'plug-shop' ),
				'description' => esc_attr__( 'This will be the banner URL', 'plug-shop' ),
				'default'     => '',
		),
		'height' => array(
				'type'        => 'text',
				'label'       => esc_attr__( 'Banner Height (px or em)', 'plug-shop' ),
				'description' => esc_attr__( 'Set the banner height. Default is 300px.', 'plug-shop' ),
				'default'     => '',
		)
	)
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
		'settings' => 'plug_shop_options[show_banners]',
		'label'    => esc_html__( 'Show Banners On:', 'plug-shop' ),
		'section'  => 'plug_shop_content',
		'type'     => 'radio-buttonset',
		'choices'  => array(
				'shop'  => esc_html__('Shop Page', 'plug-shop'),
				'all'   => esc_html__('All Shop Pages', 'plug-shop'),
				'no_single'   => esc_html__('All shop pages except single products', 'plug-shop'),
		),
		'default'  => 'shop'
) );