<?php
/**
 * Theme Customizer
 * 
 *
 *
 * @package WordPress
 * @subpackage plug shop
 * @since 1.0.0
 *
 */

# Header

Plug_Shop_Kirki::add_section( 'plug_shop_logotype', array(
	'title'       => __( 'Header', 'plug-shop' ),
	'priority'    => 15,
	'description' => esc_html__('Header related options', 'plug-shop'),
    'capability'  => 'edit_theme_options',
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings' => 'plug_shop_options[logo_height]',
	'label'    => esc_html__( 'Logo Height', 'plug-shop' ),
	'section'  => 'plug_shop_logotype',
	'type'     => 'number',
	'default'  => 50,
	'transport' => 'postMessage',
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings' => 'plug_shop_options[header_pos]',
	'label'    => esc_html__( 'Header Position', 'plug-shop' ),
	'section'  => 'plug_shop_logotype',
	'type'     => 'radio',
	'transport' => 'postMessage',
	'choices'  => array(
		'header-over'   => esc_html__( 'Over Slider', 'plug-shop' ),
		'standard'   	=> esc_html__( 'Above Slider', 'plug-shop' )
    ),
	'default'  => 'header-over',
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings'  => 'plug_shop_options[header_bg_color]',
	'label'     => esc_html__( 'Header Background Color', 'plug-shop' ),
	'section'   => 'plug_shop_logotype',
	'type'      => 'color',
	'transport' => 'postMessage',
	'default'   => 'transparent',
	'js_vars'   => array(
		array(
			'element'  => '#header .inner',
			'function' => 'css',
			'property' => 'background'
		),
	),
	'choices'     => array(
		'alpha' => true,
	),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
		'settings'  => 'plug_shop_options[menu_bg_color]',
		'label'     => esc_html__( 'Navigation Background Color', 'plug-shop' ),
		'section'   => 'plug_shop_logotype',
		'type'      => 'color',
		'transport' => 'postMessage',
		'default'   => '#f5f5f5',
		'js_vars'   => array(
				array(
						'element'  => '#header .psf-navigation-wrap',
						'function' => 'css',
						'property' => 'background'
				),
		),
		'choices'     => array(
				'alpha' => true,
		),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings' => 'plug_shop_options[menu_1st_color]',
	'label'    => esc_html__( 'Menu Elements Color', 'plug-shop' ),
	'section'  => 'plug_shop_logotype',
	'type'     => 'color',
	'transport' => 'postMessage',
	'default'  => '#606264',
	'js_vars' => array(
		array(
			'element'  => '.main-navigation .menu > li > a',
			'function' => 'css',
			'property' => 'color'
		),
	),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings' => 'plug_shop_options[menu_2nd_color]',
	'label'    => esc_html__( 'Submenu Elements Color', 'plug-shop' ),
	'section'  => 'plug_shop_logotype',
	'type'     => 'color',
	'transport' => 'postMessage',
	'default'  => '#767676',
	'js_vars' => array(
		array(
			'element'  => 'body .main-navigation .menu .sub-menu > li > a',
			'function' => 'css',
			'property' => 'color'
		),
	),
) );

Plug_Shop_Kirki::add_field( 'plug_shop', array(
	'settings' => 'plug_shop_options[menu_hcolor]',
	'label'    => esc_html__( 'Menu Elements Hover Color', 'plug-shop' ),
	'section'  => 'plug_shop_logotype',
	'type'     => 'color',
	'transport' => 'postMessage',
	'default'  => '#40c4ff',
	'js_vars' => array(
		array(
			'element'  => 'body .main-navigation .menu li:hover > a, .main-navigation .menu li.focus > a, .main-navigation .menu li.current-menu-item > a, .header-area .plug-shop-cart:hover > a, .main-navigation .menu .sub-menu>li>a:hover',
			'function' => 'css',
			'property' => 'color'
		),
		array(
				'element'  => '.header-area .plug-shop-cart > a .cart-counts',
				'function' => 'css',
				'property' => 'background-color'
		)
	),
) );