<?php
/**
 *
 * Layout Hooks:
 *
 * plug_shop_title_bg // Title background image
 * plug_shop_title_open_tag // Header title opening tag
 * plug_shop_title_heading // Main title heading
 * plug_shop_title_breadcrumbs // Breadcrumbs
 * plug_shop_title_meta // Title meta
 * plug_shop_title_close_tag // Header title closing tag
 *
 * For more information on hooks, actions, and filters, see http://codex.wordpress.org/Plugin_API.
 *
 * @package WordPress
 * @subpackage Plug Shop
 * @since 1.0.0
 *
 */


if ( !function_exists( 'plug_shop_title_bg_class' ) ) {
	/**
	 *
	 * Title background image
	 *
	 * @since  1.0.0
	 */
	function plug_shop_title_bg_class($class) {
		$post = get_queried_object();

		if ( 
			is_page() && has_post_thumbnail( $post->ID ) ||
			is_single() && has_post_thumbnail( $post->ID ) && 'yes' == plug_shop_options('bg_thumb') ||
			class_exists('woocommerce') && is_product() && 'yes' == plug_shop_options('prod_bg_thumb')
		) {
			# Class
			$class[] = 'has-title-bg';
		} 

		return array_map( 'esc_attr', $class );
	}
	add_filter( 'plug_shop_header_classes', 'plug_shop_title_bg_class' );
}

if ( !function_exists( 'plug_shop_title_bg' ) ) {
	/**
	 *
	 * Title background image
	 *
	 * @since  1.0.0
	 */
	function plug_shop_title_bg($atts) {
		$post = get_queried_object();

		if (
				is_page() && has_post_thumbnail( $post->ID ) ||
				is_single() && has_post_thumbnail( $post->ID ) && 'yes' == plug_shop_options('bg_thumb') ||
				class_exists('woocommerce') && is_product() && 'yes' == plug_shop_options('prod_bg_thumb')
			) {
				# Image
				$img_src = plug_shop_get_thumb_src($post);

				# Style
				$atts  = sprintf( 'style="background-image: url(%s);"', esc_url($img_src) );
			}

		return $atts;
	}

	add_filter( 'plug_shop_header_atts', 'plug_shop_title_bg' );
}

if ( ! function_exists( 'plug_shop_title_open_tag' ) ) {
	/**
	 * Title header opening wrap
	 *
	 * @since  1.0.0
	 */
	function plug_shop_title_open_tag()	{
		// Class.
		$class   = array( 'entry-header', 'pf-col-12' );
		$class   = apply_filters( 'plug_shop_header_classes', $class );
		$atts    = apply_filters( 'plug_shop_header_atts', '' );
		$join_cls = implode( ' ', $class );

		// Header markup.
		printf( '<div class="%s" %s>', esc_attr( $join_cls ), $atts );
	}

	add_action( 'plug_shop_title', 'plug_shop_title_open_tag', 1 );
}


if ( ! function_exists( 'plug_shop_title_heading' ) ) {
	/**
	 * Title Heading
	 *
	 * @since  1.0.0
	 */
	function plug_shop_title_heading() {
		$title_wrap = array( 'title-wrap', 'breadcrumbs' );
		$title_wrap = apply_filters( 'plug_shop_title_wrap_class', $title_wrap );
		$post_id    = get_queried_object_id();
		$title_class = join( ' ', $title_wrap );
		?>

		<div class="<?php echo esc_attr($title_class); ?>">
			<h1 class="entry-title">
			<?php  if ( is_day() ) : 
					printf( '%s %s', esc_html__( 'Daily Archives:', 'plug-shop' ), get_the_date() );

				elseif ( is_month() ) :
					printf( '%s %s', esc_html__( 'Monthly Archives:', 'plug-shop' ), get_the_date('F Y') );

				elseif ( is_year() ) :
					printf( '%s %s', esc_html__( 'Yearly Archives:', 'plug-shop' ), get_the_date('Y') );

				elseif ( plug_shop_is_wc_installed() && plug_shop_is_wc_template() && ! is_product() ):
					woocommerce_page_title();

				elseif( is_category() ) :
					printf( '%s %s', esc_html__( 'Category Archives:', 'plug-shop' ), single_cat_title( '', false ) );

				elseif( is_author() ):
					printf( '%s %s', esc_html__( 'Author Archives:', 'plug-shop' ), get_the_author() );

				elseif( is_tag() ) :
					printf( '%s %s', esc_html__( 'Tag: ', 'plug-shop' ), get_query_var('tag') );

				elseif( is_archive() ):
					esc_html_e( 'Blog Archives', 'plug-shop' );
					the_archive_description();

				elseif( is_search() ):
					echo plug_shop_get_search_title();

				elseif( is_home() ):
					return;

				else:
				   echo get_the_title($post_id);

				endif; 
			?>
			</h1>
		<?php
	}
	add_action( 'plug_shop_title', 'plug_shop_title_heading', 2 );
}

/**
 * 
 * Breadcrumbs
 *
 * @since  1.0.0
 */
if ( !function_exists( 'plug_shop_title_breadcrumbs' ) )
{
	function plug_shop_title_breadcrumbs()
	{
		new Plug_Shop_Breadcrumbs;

		echo '</div>';
	}
	add_action( 'plug_shop_title', 'plug_shop_title_breadcrumbs', 3 );
}


if ( !function_exists( 'plug_shop_title_meta' ) ) {
	/**
	 *
	 * Title Meta
	 *
	 * @since  1.0.0
	 */
	function plug_shop_title_meta()	{
		$meta = apply_filters( 'plug_shop_title_meta', true );
		if( $meta && is_singular() ): ?>

			<div class="entry-meta">
				<?php plug_shop_posted_on(); ?>
			</div><!-- .entry-meta -->

		<?php endif;
	}

	add_action( 'plug_shop_title', 'plug_shop_title_meta', 4 );
}


if ( !function_exists( 'plug_shop_title_close_tag' ) ) {
	/**
	 *
	 * Title header closing wrap
	 *
	 * @since  1.0.0
	 */
	function plug_shop_title_close_tag() {
		echo '</div><!-- .entry-header -->';
	}

	add_action( 'plug_shop_title', 'plug_shop_title_close_tag', 5 );
}