<?php
/**
 *
 * Layout Hooks:
 *
 * plug_shop_single_post_thumb // Blog post thumbnail
 * plug_shop_single_post_content_open // Blog post cotnent opening tag
 * plug_shop_single_post_content // Blog post content
 * plug_shop_single_post_content_close // Blog post content closing tag
 * plug_shop_single_post_author_box // Blog post author box
 * plug_shop_single_post_utility // Blog post utility - tags, categories
 * plug_shop_post_navs // Post navigation
 * plug_shop_comment_form // Comment form
 * plug_shop_related_posts_hook // Related posts section
 *
 * For more information on hooks, actions, and filters, see http://codex.wordpress.org/Plugin_API.
 *
 * @package WordPress
 * @subpackage Plug Shop
 * @since 1.0.0
 *
 */


if ( !function_exists( 'plug_shop_single_post_thumb' ) ) {
	/**
	 * Blog post thumbnail
	 *
	 * @since  1.0.0
	 */
	function plug_shop_single_post_thumb() {
		echo '<div class="post-thumb">';
		do_action('plug_shop_post_thumbnail');
		echo '</div>';
	}

	add_action( 'plug_shop_single_post_markup', 'plug_shop_single_post_thumb', 2 );
}

if ( !function_exists( 'plug_shop_single_post_content_open' ) ) {
	/**
	 * Blog post content opening tag
	 *
	 * @since  1.0.0
	 */
	function plug_shop_single_post_content_open() {
		?>
			<div class="entry-content">
		<?php
	}

	add_action( 'plug_shop_single_post_markup', 'plug_shop_single_post_content_open', 3 );
}



if ( !function_exists( 'plug_shop_single_post_content' ) ) {
	/**
	 * Blog post content
	 *
	 * @since  1.0.0
	 */
	function plug_shop_single_post_content() {
		the_content( sprintf('%1$s %2$s', esc_html__( 'Continue reading', 'plug-shop' ), '<span class="meta-nav">&rarr;</span>' ) );

		wp_link_pages( array( 'before' => '<div class="page-link">' . esc_html__( 'Pages:', 'plug-shop' ), 'after' => '</div>' ) );
	}

	add_action( 'plug_shop_single_post_markup', 'plug_shop_single_post_content', 4 );
}


if ( !function_exists( 'plug_shop_single_post_content_close' ) ) {
	/**
	 * Blog post content closing tag
	 *
	 * @since  1.0.0
	 */
	function plug_shop_single_post_content_close() {
		?>
			</div><!-- .entry-content -->
		<?php
	}
	add_action( 'plug_shop_single_post_markup', 'plug_shop_single_post_content_close', 5 );
}

if ( !function_exists( 'plug_shop_single_post_utility' ) ) {
	/**
	 * Blog post utility
	 *
	 * @since  1.0.0
	 */
	function plug_shop_single_post_utility() {
		plug_shop_get_part('utility');
	}
	add_action( 'plug_shop_single_post_markup', 'plug_shop_single_post_utility', 6 );
}

if ( !function_exists( 'plug_shop_single_post_author_box' ) ) {
	/**
	 * Blog post author box
	 *
	 * @since  1.0.0
	 */
	function plug_shop_single_post_author_box() {
		// If a user has filled out their description, show a bio on their entries  
		if ( get_the_author_meta( 'description' ) )
		{
			plug_shop_get_part('author-box');
		}
	}
	add_action( 'plug_shop_single_post_markup', 'plug_shop_single_post_author_box', 8 );
}

if ( !function_exists( 'plug_shop_post_navs' ) ) {
	/**
	 * Post navigation
	 *
	 * @since  1.0.0
	 */
	function plug_shop_post_navs() {
		if( is_singular() ) {
			do_action('plug_shop_page_navi');
		}
	}

	add_action( 'plug_shop_single_after', 'plug_shop_post_navs', 1 );
}

if ( !function_exists( 'plug_shop_comment_form' ) ) {
	/**
	 * Comment Form
	 *
	 * @since  1.0.0
	 */
	function plug_shop_comment_form() {
		// If comments are open or we have at least one comment, load up the comment template.
		if ( comments_open() || get_comments_number() ) {
			comments_template('', true);
		}
	}

	add_action( 'plug_shop_single_after', 'plug_shop_comment_form', 3 );
}
