<?php
/**
 * Layout Hooks:
 *
 * plug_shop_sidebar_wrap // Opening content wrapper
 * plug_shop_sidebar_wrap_close // Closing content wrapper
 * plug_shop_sidebar_position // Position of the sidebar left | right
 * plug_shop_sidebar_width // Sidebar width, number of columns
 *
 * For more information on hooks, actions, and filters, see http://codex.wordpress.org/Plugin_API.
 *
 * @package WordPress
 * @subpackage Plug Shop
 * @since 1.0.0
 *
 */


if ( !function_exists( 'plug_shop_sidebar_wrap' ) )  {
	/**
	 *
	 * Sidebar Wrap Markup - plug_shop_sidebar_wrap()
	 * Be sure to add the excess of 16 to plug_shop_content_wrap() as well
	 *
	 * @since  1.0.0
	 */
	function plug_shop_sidebar_wrap() {

		$columns = '';
		$columns = apply_filters('plug_shop_set_sidebarwidth', $columns, 1);

		echo sprintf('<div id="sidebar" class="pf-col-12 %s" role="complementary">', esc_attr($columns) );

	}

	add_action( 'plug_shop_before_sidebar', 'plug_shop_sidebar_wrap', 1 );

}


if ( !function_exists( 'plug_shop_sidebar_wrap_close' ) ) {
	/**
	 *
	 * After Sidebar Markup
	 *
	 * @since  1.0.0
	 */
	function plug_shop_sidebar_wrap_close() {
	   echo '</div><!-- #sidebar -->';
	}
	add_action( 'plug_shop_after_sidebar', 'plug_shop_sidebar_wrap_close');
}


if ( !function_exists( 'plug_shop_sidebar_position' ) ){
	/**
	 *
	 * Sidebar Positioning Utility (sidebar-left | sidebar-right)
	 * Sets a body class for source ordered sidebar positioning
	 *
	 * @param  array        $class
	 * @return array
	 * @since  1.0.0
	 */
	function plug_shop_sidebar_position($class) {
		$sidebar_position = plug_shop_options('sidebar_position', 'right');
		$sidebar_position = ($sidebar_position == "right" ? "right" : "left");
		$class[] = 'sidebar-'.$sidebar_position;

		return $class;
	}

	add_filter('body_class','plug_shop_sidebar_position');
}


if ( !function_exists( 'plug_shop_sidebar_width' ) ) {
	/**
	 *
	 * Filterable utility function to set the sidebar width - plug_shop_sidebar_width()
	 * Specifies the column classes via conditional statements
	 * See http://codex.wordpress.org/Conditional_Tags for a full list
	 *
	 * @return string
	 * @since  1.0.0
	 */
	function plug_shop_sidebar_width() 	{
		global $post;
		$columns = plug_shop_options('sidebar_width', '3');

		// Single Posts
		if ( is_single() && ! is_singular( 'product' ) ) {
			// Check for custom field of sidebars => false
			$post_wide = get_post_meta($post->ID, "sidebars", true) ==  "false";

			// make sure no Post widgets are active
			if ( ! is_active_sidebar('sidebar-1') || $post_wide ) {
				$columns = false;
			}
		}

		return sprintf('pf-col-lg-%s', esc_attr($columns) );
	}

	add_filter('plug_shop_set_sidebarwidth', 'plug_shop_sidebar_width', 10, 1);

}

if ( !function_exists( 'plug_shop_sidebar_output' ) ) {
	/**
	 *
	 * Call sidebar based on the post type
	 *
	 * @return string
	 * @since  1.0.0
	 */
	function plug_shop_sidebar_output() {
		if( is_page() || is_home() ) {
			dynamic_sidebar( 'sidebar-2' );
		}
		else if( is_singular() && ! plug_shop_is_wc_template() ) {
			dynamic_sidebar( 'sidebar-1' );
		}
		else if( plug_shop_is_wc_template() ) {
			dynamic_sidebar( 'sidebar-3' );
		}
		else {
			dynamic_sidebar( 'sidebar-1' );
		}
	}
	add_action('plug_shop_sidebar', 'plug_shop_sidebar_output');
}