<?php


/**
 * Homepage
 *
 * @see  plug_shop_homepage_content()
 * @see  plug_shop_product_categories()
 * @see  plug_shop_recent_products()
 * @see  plug_shop_featured_products()
 * @see  plug_shop_popular_products()
 * @see  plug_shop_on_sale_products()
 * @see  plug_shop_best_selling_products()
 */
add_action( 'homepage', 'plug_shop_homepage_content',      10 );
add_action( 'homepage', 'plug_shop_product_categories',    20 );
add_action( 'homepage', 'plug_shop_recent_products',       30 );
add_action( 'homepage', 'plug_shop_featured_products',     40 );
add_action( 'homepage', 'plug_shop_popular_products',      50 );
add_action( 'homepage', 'plug_shop_on_sale_products',      60 );
add_action( 'homepage', 'plug_shop_best_selling_products', 70 );


if ( ! function_exists( 'plug_shop_homepage_content' ) ) {
	/**
	 * Display Page Content
	 * Hooked into the `homepage` action in the homepage template
	 *
	 * @since  1.0.0
	 * @param array $args the product section args.
	 * @return void
	 */
	function plug_shop_homepage_content( $args ) {
		plug_shop_get_content('page');
	}
}

if ( ! function_exists( 'plug_shop_product_categories' ) ) {
	/**
	 * Display Product Categories
	 * Hooked into the `homepage` action in the homepage template
	 *
	 * @since  1.0.0
	 * @param array $args the product section args.
	 * @return void
	 */
	function plug_shop_product_categories( $args ) {

		if ( plug_shop_is_wc_installed() ) {

			$args = apply_filters( 'plug_shop_product_categories_args', array(
				'limit' 			=> 3,
				'columns' 			=> 3,
				'child_categories' 	=> 0,
				'orderby' 			=> 'name',
				'title'				=> __( 'Shop by Category', 'plug-shop' ),
			) );

			$shortcode_content = plug_shop_do_shortcode( 'product_categories', apply_filters( 'plug_shop_product_categories_shortcode_args', array(
				'number'  => intval( $args['limit'] ),
				'columns' => intval( $args['columns'] ),
				'orderby' => esc_attr( $args['orderby'] ),
				'parent'  => esc_attr( $args['child_categories'] ),
			) ) );

			/**
			 * Only display the section if the shortcode returns product categories
			 */
			if ( false !== strpos( $shortcode_content, 'product-category' ) ) {

				echo '<section class="psf-product-section psf-product-categories" aria-label="' . esc_attr__( 'Product Categories', 'plug-shop' ) . '">';

				do_action( 'plug_shop_homepage_before_product_categories' );

				echo '<h2 class="section-title">' . wp_kses_post( $args['title'] ) . '</h2>';

				do_action( 'plug_shop_homepage_after_product_categories_title' );

				echo $shortcode_content;

				do_action( 'plug_shop_homepage_after_product_categories' );

				echo '</section>';

			}
		}
	}
}

if ( ! function_exists( 'plug_shop_recent_products' ) ) {
	/**
	 * Display Recent Products
	 * Hooked into the `homepage` action in the homepage template
	 *
	 * @since  1.0.0
	 * @param array $args the product section args.
	 * @return void
	 */
	function plug_shop_recent_products( $args ) {

		if ( plug_shop_is_wc_installed() ) {

			$args = apply_filters( 'plug_shop_recent_products_args', array(
				'limit' 			=> 4,
				'columns' 			=> 4,
				'title'				=> __( 'Newest Products', 'plug-shop' ),
			) );

			$shortcode_content = plug_shop_do_shortcode( 'recent_products', apply_filters( 'plug_shop_recent_products_shortcode_args', array(
				'per_page' => intval( $args['limit'] ),
				'columns'  => intval( $args['columns'] ),
			) ) );

			/**
			 * Only display the section if the shortcode returns products
			 */
			if ( false !== strpos( $shortcode_content, 'product' ) ) {

				echo '<section class="psf-product-section psf-recent-products" aria-label="' . esc_attr__( 'Recent Products', 'plug-shop' ) . '">';

				do_action( 'plug_shop_homepage_before_recent_products' );

				echo '<h2 class="section-title">' . wp_kses_post( $args['title'] ) . '</h2>';

				do_action( 'plug_shop_homepage_after_recent_products_title' );

				echo $shortcode_content;

				do_action( 'plug_shop_homepage_after_recent_products' );

				echo '</section>';

			}
		}
	}
}

if ( ! function_exists( 'plug_shop_featured_products' ) ) {
	/**
	 * Display Featured Products
	 * Hooked into the `homepage` action in the homepage template
	 *
	 * @since  1.0.0
	 * @param array $args the product section args.
	 * @return void
	 */
	function plug_shop_featured_products( $args ) {

		if ( plug_shop_is_wc_installed() ) {

			$args = apply_filters( 'plug_shop_featured_products_args', array(
				'limit'   => 4,
				'columns' => 4,
				'orderby' => 'date',
				'order'   => 'desc',
				'title'   => __( 'Our Recommendation', 'plug-shop' ),
			) );

			$shortcode_content = plug_shop_do_shortcode( 'featured_products', apply_filters( 'plug_shop_featured_products_shortcode_args', array(
				'per_page' => intval( $args['limit'] ),
				'columns'  => intval( $args['columns'] ),
				'orderby'  => esc_attr( $args['orderby'] ),
				'order'    => esc_attr( $args['order'] ),
			) ) );

			/**
			 * Only display the section if the shortcode returns products
			 */
			if ( false !== strpos( $shortcode_content, 'product' ) ) {

				echo '<section class="psf-product-section psf-featured-products" aria-label="' . esc_attr__( 'Featured Products', 'plug-shop' ) . '">';

				do_action( 'plug_shop_homepage_before_featured_products' );

				echo '<h2 class="section-title">' . wp_kses_post( $args['title'] ) . '</h2>';

				do_action( 'plug_shop_homepage_after_featured_products_title' );

				echo $shortcode_content;

				do_action( 'plug_shop_homepage_after_featured_products' );

				echo '</section>';

			}
		}
	}
}

if ( ! function_exists( 'plug_shop_popular_products' ) ) {
	/**
	 * Display Popular Products
	 * Hooked into the `homepage` action in the homepage template
	 *
	 * @since  1.0.0
	 * @param array $args the product section args.
	 * @return void
	 */
	function plug_shop_popular_products( $args ) {

		if ( plug_shop_is_wc_installed() ) {

			$args = apply_filters( 'plug_shop_popular_products_args', array(
				'limit'   => 4,
				'columns' => 4,
				'title'   => __( 'Top Rated Products', 'plug-shop' ),
			) );

			$shortcode_content = plug_shop_do_shortcode( 'top_rated_products', apply_filters( 'plug_shop_popular_products_shortcode_args', array(
				'per_page' => intval( $args['limit'] ),
				'columns'  => intval( $args['columns'] ),
			) ) );

			/**
			 * Only display the section if the shortcode returns products
			 */
			if ( false !== strpos( $shortcode_content, 'product' ) ) {

				echo '<section class="psf-product-section psf-popular-products" aria-label="' . esc_attr__( 'Popular Products', 'plug-shop' ) . '">';

				do_action( 'plug_shop_homepage_before_popular_products' );

				echo '<h2 class="section-title">' . wp_kses_post( $args['title'] ) . '</h2>';

				do_action( 'plug_shop_homepage_after_popular_products_title' );

				echo $shortcode_content;

				do_action( 'plug_shop_homepage_after_popular_products' );

				echo '</section>';

			}
		}
	}
}

if ( ! function_exists( 'plug_shop_on_sale_products' ) ) {
	/**
	 * Display On Sale Products
	 * Hooked into the `homepage` action in the homepage template
	 *
	 * @param array $args the product section args.
	 * @since  1.0.0
	 * @return void
	 */
	function plug_shop_on_sale_products( $args ) {

		if ( plug_shop_is_wc_installed() ) {

			$args = apply_filters( 'plug_shop_on_sale_products_args', array(
				'limit'   => 4,
				'columns' => 4,
				'title'   => __( 'On Sale', 'plug-shop' ),
			) );

			$shortcode_content = plug_shop_do_shortcode( 'sale_products', apply_filters( 'plug_shop_on_sale_products_shortcode_args', array(
				'per_page' => intval( $args['limit'] ),
				'columns'  => intval( $args['columns'] ),
			) ) );

			/**
			 * Only display the section if the shortcode returns products
			 */
			if ( false !== strpos( $shortcode_content, 'product' ) ) {

				echo '<section class="psf-product-section psf-on-sale-products" aria-label="' . esc_attr__( 'On Sale Products', 'plug-shop' ) . '">';

				do_action( 'plug_shop_homepage_before_on_sale_products' );

				echo '<h2 class="section-title">' . wp_kses_post( $args['title'] ) . '</h2>';

				do_action( 'plug_shop_homepage_after_on_sale_products_title' );

				echo $shortcode_content;

				do_action( 'plug_shop_homepage_after_on_sale_products' );

				echo '</section>';

			}
		}
	}
}

if ( ! function_exists( 'plug_shop_best_selling_products' ) ) {
	/**
	 * Display Best Selling Products
	 * Hooked into the `homepage` action in the homepage template
	 *
	 * @since 2.0.0
	 * @param array $args the product section args.
	 * @return void
	 */
	function plug_shop_best_selling_products( $args ) {
		if ( plug_shop_is_wc_installed() ) {

			$args = apply_filters( 'plug_shop_best_selling_products_args', array(
				'limit'   => 4,
				'columns' => 4,
				'title'	  => esc_attr__( 'Best Sellers', 'plug-shop' ),
			) );

			$shortcode_content = plug_shop_do_shortcode( 'best_selling_products', apply_filters( 'plug_shop_best_selling_products_shortcode_args', array(
				'per_page' => intval( $args['limit'] ),
				'columns'  => intval( $args['columns'] ),
			) ) );

			/**
			 * Only display the section if the shortcode returns products
			 */
			if ( false !== strpos( $shortcode_content, 'product' ) ) {

				echo '<section class="psf-product-section psf-best-selling-products" aria-label="' . esc_attr__( 'Best Selling Products', 'plug-shop' ) . '">';

				do_action( 'plug_shop_homepage_before_best_selling_products' );

				echo '<h2 class="section-title">' . wp_kses_post( $args['title'] ) . '</h2>';

				do_action( 'plug_shop_homepage_after_best_selling_products_title' );

				echo $shortcode_content;

				do_action( 'plug_shop_homepage_after_best_selling_products' );

				echo '</section>';

			}
		}
	}
}