<?php
/**
 * Layout Hooks:
 *
 * plug_shop_wp_title // Handles the document title
 * plug_shop_header_open // Opening header tag
 * plug_shop_header_classes // Header Classes
 * plug_shop_logo // Header logo
 * plug_shop_main_menu // Navigation hook
 * plug_shop_main_slider // Add main slider shortcode
 * plug_shop_header_inner_close // Close inner cheader container
 * plug_shop_header_title // Single post/page title
 * plug_shop_header_close // Header closing tag
 *
 * For more information on hooks, actions, and filters, see http://codex.wordpress.org/Plugin_API.
 *
 * @package WordPress
 * @subpackage Plug Shop
 * @since 1.0.0
 *
 */

/*-----------------------------------------------------------------------------------*/
/* Filters wp_title to print a proper <title> tag based on content
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'plug_shop_wp_title' ) ) {
	function plug_shop_wp_title( $title ) {
		global $page, $paged;

		if ( is_feed() )
			return $title;

		$separator = '-';

		$site_description = get_bloginfo( 'description', 'display' );

		if ( is_front_page() ) {
			$title = get_bloginfo( 'name' ) . $separator . ' ' . get_bloginfo( 'description' );

		} elseif ( is_singular() || is_home() ) {
			$title = single_post_title('', false);

		} elseif ( is_category() ) {
			$title = single_cat_title('', false);

		} elseif ( is_tag() ) {
			$title = single_tag_title('', false);

		} elseif ( is_tax() ) {
			$title = single_term_title('', false);

		} elseif ( is_post_type_archive() ) {
			$title = post_type_archive_title('', false);

		} elseif ( is_author() ) {
			$title = plug_shop_single_author_title();

		} elseif ( get_query_var( 'minute' ) && get_query_var( 'hour' ) ) {
			$title = plug_shop_get_single_minute_hour_title();

		} elseif ( get_query_var( 'minute' ) ) {
			$title = plug_shop_get_single_minute_title();

		} elseif ( get_query_var( 'hour' ) ) {
			$title = plug_shop_get_single_hour_title();

		} elseif ( is_day() ) {
			$title = plug_shop_get_single_day_title();

		} elseif ( get_query_var( 'w' ) ) {
			$title = plug_shop_get_single_week_title();

		} elseif ( is_month() ) {
			$title = single_month_title( ' ', false );

		} elseif ( is_year() ) {
			$title = plug_shop_get_single_year_title();

		} elseif ( is_archive() ) {
			$title = plug_shop_get_single_archive_title();

		} elseif ( is_search() ) {
			$title = plug_shop_get_search_title();

		} elseif ( is_404() ) {
			$title = plug_shop_get_404_title();
		} //End statment;

		if ( $site_description && ( is_home() || is_front_page() ) ) {
			$title .= " $separator $site_description";
		}

		// If the current page is a paged page.
		if ( ( $page === get_query_var( 'paged' ) || $page === get_query_var( 'page' ) ) && $page > 1 ) {
			// Translators: 1 is the page title. 2 is the page number.
			$title = sprintf( __( '%1$s Page %2$s', 'plug-shop' ), $title . $separator, number_format_i18n( absint( $page ) ) );
		}

		// Trim separator + space from beginning and end.
		$title = trim( strip_tags( $title ), "{$separator} " );

		return apply_filters( 'plug_shop_child_wp_title', $title );
	}
}
add_filter( 'pre_get_document_title', 'plug_shop_wp_title', 10, 1 );


/*-----------------------------------------------------------------------------------*/
// Opening #header
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'plug_shop_header_open' ) ) {

	function plug_shop_header_open() {
		$layout = plug_shop_options('layout', '1200');
		if( is_page_template('templates/page-full.php') ) {
			$layout = 'full';
		}

		$classes = array('pf-col-12', 'inner');
		$classes = apply_filters( 'plug_shop_header_class', $classes );
		$classes = implode( ' ', $classes );

		printf('<div id="pf-wrap" class="%s">', 'full' === $layout ? 'pf-container-fluid' : 'pf-container');
	  	echo '<div id="header" class="pf-row">';
		echo "\n" . '<div class="'. esc_attr($classes). '">' . "\n";
		echo '<div class="pf-row">';
	}

	add_action('plug_shop_header','plug_shop_header_open', 10);
}


/*-----------------------------------------------------------------------------------*/
// Header classes
/*-----------------------------------------------------------------------------------*/
if( !function_exists( 'plug_shop_header_classes' ) )
{
	function plug_shop_header_classes($classes) {
		$position = plug_shop_options('header_pos');

		if ( '' == $position ) {
			$position = 'standard';
		}

		$classes[] = esc_attr($position);

		return $classes;
	}

	add_filter('plug_shop_header_class', 'plug_shop_header_classes' );
}



/*-----------------------------------------------------------------------------------*/
/* Header Logo
/*-----------------------------------------------------------------------------------*/


if ( !function_exists( 'plug_shop_logo' ) )
{

	function plug_shop_logo()
	{
		/*
		 * Output the modified logo markup
		 *
		 * We have already made the conditional check
		 * in filter if logo is present, and if not
		 * the site tag line is displayed, so there is
		 * no need to make an additional check before calling
		 * the custom logo function
		 */
		$logo = get_custom_logo();

		echo wp_kses( $logo, array(
			'div'  => array(
				'class' => true
			),
			'a' => array(
				'id'       => true,
				'class'    => true,
				'href'     => true,
				'title'    => true,
				'rel'      => true,
				'style'    => true,
				'itemprop' => true
			),
			'img'  => array(
				'src'      => true,
				'itemprop' => true,
				'width'    => true,
				'height'   => true
			),
			'span' => array(
				'class' => true
			)
		) );
	}

	add_action('plug_shop_header','plug_shop_logo', 20);
}


/*-----------------------------------------------------------------------------------*/
/* Top header part for search and cart widgets
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'plug_shop_top_header_widgets' ) ) {

	function plug_shop_top_header_widgets() {
		?>
		<div class="pf-col-md-8">
			<div class="psf-logoarea-widgets">
				<?php do_action('plug_shop_logo_area_widgets'); ?>
			</div>
		</div>
		<?php
	}

	add_action('plug_shop_header','plug_shop_top_header_widgets', 30);
}


/*-----------------------------------------------------------------------------------*/
/* Closes the header inner markup
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'plug_shop_header_inner_close' ) ) {

	function plug_shop_header_inner_close() {
		echo "</div>"."\n";
		echo "</div>"."\n";
	}

	add_action('plug_shop_header','plug_shop_header_inner_close', 40);
}

/*-----------------------------------------------------------------------------------*/
/* Closes the header inner markup
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'plug_shop_header_mob_menu_icon' ) ) {

	function plug_shop_header_mob_menu_icon() {
		echo '<span class="nav-collapse">
			   <b></b>
			   <b></b>
			   <b></b>
		</span>' . "\n";
	}

	add_action('plug_shop_header','plug_shop_header_mob_menu_icon', 60);
}


/*-----------------------------------------------------------------------------------*/
/* Main menu opening wrapper
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'plug_shop_navigation_tag_open' ) ) {

	function plug_shop_navigation_tag_open() {
		echo "<div class='psf-navigation-wrap pf-col-12'>"."\n";
	}

	add_action('plug_shop_header','plug_shop_navigation_tag_open', 50);

}

/*-----------------------------------------------------------------------------------*/
/* Navigation Hook (plug_shop_main_menu)
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'plug_shop_main_menu' ) ) {

	function plug_shop_main_menu() {
		# Menu parameters
		$args = apply_filters( 'plug_shop_main_menu_args', array(
			'container_class' => 'menu-header clearfix', 
			'theme_location' => 'primary'
		) );

		# Navigation classes
		$nav_class = array( 'main-navigation' );
		$nav_class = apply_filters( 'plug_shop_navigation_class', $nav_class );
		$nav_class = implode( ' ', $nav_class );

		# Output
		printf( '<div id="navigation" class="%s">', esc_attr($nav_class) );
		plug_shop_get_menu($args);
		echo '</div><!--/#navigation-->';
	}

	add_action('plug_shop_header','plug_shop_main_menu', 60);
}



/*-----------------------------------------------------------------------------------*/
/* Add widget to the header
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'plug_shop_header_widget' ) ) {

	function plug_shop_header_widget() {
		echo "<div class='header-area'>"."\n";
		echo '<div class="header-area-inner">';
		dynamic_sidebar('sidebar-header');
		do_action('plug_shop_after_header_widget');
	}

	add_action('plug_shop_header','plug_shop_header_widget', 70);

}

if ( ! function_exists( 'plug_shop_header_cart_link' ) ) {
	/**
	 * Cart Link
	 * Displayed a link to the cart including the number of items present and the cart total
	 *
	 * @return void
	 * @since  1.0.0
	 */
	function plug_shop_header_cart_link() {
		plug_shop_cart_link();
	}

	add_action('plug_shop_after_header_widget', 'plug_shop_header_cart_link');
}

if ( ! function_exists( 'plug_shop_my_account_link' ) ) {
	/**
	 * Display My Account Link
	 *
	 * @since  1.0.0
	 * @return void
	 */
	function plug_shop_my_account_link() {
		if ( plug_shop_is_wc_installed() ) { ?>
			<div class="psf-my-account">
				<?php if ( is_user_logged_in() ) { ?>
					<a href="<?php echo esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ); ?>" title="<?php esc_attr_e('My Account','plug-shop'); ?>">
						<span class="icon-user-1"></span>
						<span><?php esc_html_e('My Account','plug-shop'); ?></span>
					</a>
				<?php }
				else { ?>
					<a href="<?php echo esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ); ?>" title="<?php esc_attr_e('Login / Register','plug-shop'); ?>">
						<span class="icon-user-1"></span>
						<span><?php esc_html_e('Login / Register','plug-shop'); ?></span>
					</a>
				<?php } ?>
			</div>
		<?php
		}
	}

	add_action('plug_shop_logo_area_widgets', 'plug_shop_my_account_link');
}

if ( ! function_exists( 'plug_shop_product_search' ) ) {
	/**
	 * Display Product Search
	 *
	 * @since  1.0.0
	 * @return void
	 */
	function plug_shop_product_search() {
		if ( plug_shop_is_wc_installed() ) { ?>
			<div class="site-search">
				<?php the_widget( 'WC_Widget_Product_Search', 'title=' ); ?>
			</div>
		<?php
		}
	}

	add_action('plug_shop_logo_area_widgets', 'plug_shop_product_search', 20);
}

/*-----------------------------------------------------------------------------------*/
/* Main menu opening wrapper
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'plug_shop_navigation_tag_close' ) ) {

	function plug_shop_navigation_tag_close() {
		echo "</div>"."\n";
		echo "</div>"."\n";
		echo "</div>"."\n";
	}

	add_action('plug_shop_header','plug_shop_navigation_tag_close', 80);

}

/*-----------------------------------------------------------------------------------*/
// Append slider to the header
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'plug_shop_main_slider' ) ) {

	function plug_shop_main_slider() {
		$shortcode = plug_shop_options('slider');
		$show      = plug_shop_options('slider_place', 'home');

		if( 'home' == $show && ( !is_home() && !is_front_page() ) ) {
			$shortcode = '';
		}

		if( '' !== $shortcode && strstr( $shortcode, '[' ) ) {
			echo '<div class="pf-col-12 pf-slider-wrap">';
				echo do_shortcode($shortcode);
			echo '</div>';
		} else {
			plug_shop_custom_header_media();
		}

	}

	add_action('plug_shop_header','plug_shop_main_slider', 90);
}

/*-----------------------------------------------------------------------------------*/
// Append custom header media, if slider is not used
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'plug_shop_custom_header_media' ) ) {

	function plug_shop_custom_header_media() {

			echo '<div class="custom-header">';
				echo '<div class="custom-header-media">';
				the_custom_header_markup();
				echo '</div>';
			echo '</div><!-- .custom-header -->';
	}
}

/*-----------------------------------------------------------------------------------*/
/* Adds single title 
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'plug_shop_header_title' ) ) {

	function plug_shop_header_title() {
		if( ! is_page_template('templates/page-full.php') && ! is_home() && ! is_page_template('templates/homepage.php') && ! is_page_template('templates/homepage-sidebar.php' ) && ! is_404() ) {
				plug_shop_get_part('title');
		}
	}

	add_action('plug_shop_header','plug_shop_header_title', 100);
}

/*-----------------------------------------------------------------------------------*/
/* Closes the #header markup
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'plug_shop_header_close' ) ) {

	function plug_shop_header_close() {
		echo "</div>"."\n";
		echo "<!--/#header-->"."\n";
	}

	add_action('plug_shop_header','plug_shop_header_close', 110);
}