<?php
/**
 * Layout Hooks:
 *
 * plug_shop_footer // Create the footer action
 * plug_shop_before_footer // footer opening tag
 * plug_shop_footer_widgets // get footer sidebar
 * plug_shop_footer_nav // Footer navigation
 * plug_shop_footer_credits // Footer credits text
 * plug_shop_after_footer // Footer closing tags
 *
 * For more information on hooks, actions, and filters, see http://codex.wordpress.org/Plugin_API.
 *
 * @package WordPress
 * @subpackage Plug Shop
 * @since 1.0.0
 *
 */


/*-----------------------------------------------------------------------------------*/
// Global hook for footer actions
/*-----------------------------------------------------------------------------------*/

function plug_shop_footer() {
	do_action('plug_shop_footer');
}

add_action('wp_footer', 'plug_shop_footer',1);


/*-----------------------------------------------------------------------------------*/
/* Before Footer
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists('plug_shop_before_footer') )  {

    function plug_shop_before_footer() {
		$footerwidgets = is_active_sidebar('footer-widget-area-1') + is_active_sidebar('footer-widget-area-2') + is_active_sidebar('footer-widget-area-3') + is_active_sidebar('footer-widget-area-4');
		$class = ($footerwidgets == '0' ? 'noborder' : 'normal');

		printf( '<div id="footer" class="%s pf-row">', esc_attr($class) );
    }

    add_action('plug_shop_footer', 'plug_shop_before_footer',11);
}


/*-----------------------------------------------------------------------------------*/
// Footer Widgets
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists('plug_shop_footer_widgets') )  {

	function plug_shop_footer_widgets() {
		plug_shop_get_sidebar( 'footer' );
	}

	add_action('plug_shop_footer', 'plug_shop_footer_widgets',20);
}


/*-----------------------------------------------------------------------------------*/
// Footer Navigation
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'plug_shop_footer_nav' ) ) {

	function plug_shop_footer_nav() {

		$defaults = array(
			'theme_location' => 'footer',
			'container'      => 'div',
			'container_id'   => 'footermenu',
			'menu_class'     => 'menu',
			'echo'           => true,
			'fallback_cb'    => false,
			'after'          => '<span> | </span>',
			'depth'          => 1);

		wp_nav_menu($defaults);
	}

	add_action('plug_shop_footer', 'plug_shop_footer_nav',30);
}


/*-----------------------------------------------------------------------------------*/
/* Footer Credits
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'plug_shop_footer_credits' ) ) {

	function plug_shop_footer_credits() {
		$default = sprintf('%1$s <a href="%2$s" title="%3$s">%4$s</a>',
				esc_html__('Lovely WordPress Theme developed by', 'plug-shop'),
				esc_url('http://www.pressfore.com'),
				esc_attr__('Pressfore WordPress Themes', 'plug-shop'),
				esc_html__('Pressfore','plug-shop')
		);

		$footer_extras = '' != plug_shop_options('footer_extras', $default) ? plug_shop_options('footer_extras', $default) : $default;
 
		$extras  = '<div id="credits" class="pf-col-12">';
		$extras .= $footer_extras;
		$extras .= "</div>";

		$extras = apply_filters( 'plug_shop_author_credits', $extras );

		echo wp_kses($extras, array(
			'div'   => array(
				'id'  => true,
				'class' => true
			),
			'span'  => array(
					'class' => true
			),
			'a'   => array(
					'class' => true,
					'href'  => true,
					'title'	=> true
			),
			'i'      => true,
			'strong' => true
		) );
	}
	add_action('plug_shop_footer', 'plug_shop_footer_credits',40);
}


/*-----------------------------------------------------------------------------------*/
/* After Footer
/*-----------------------------------------------------------------------------------*/

if (!function_exists('plug_shop_after_footer'))  {

    function plug_shop_after_footer() {
			echo "</div><!--/#footer-->"."\n";
			echo "</div><!--/#wrap.container-->"."\n";
    }

	add_action('plug_shop_footer', 'plug_shop_after_footer',50);
}
