<?php
/**
 * Layout Hooks:
 *
 * plug_shop_rolo_slider // Add rolo-active class if rolo is active
 * plug_shop_plugins_hook // Add the filter after all pluigns have been loaded
 * plug_shop_do_shortcode // Execute the shortcode by its tag
 *
 * For more information on hooks, actions, and filters, see http://codex.wordpress.org/Plugin_API.
 *
 * @package WordPress
 * @subpackage Plug Shop
 * @since 1.0.0
 *
 */


if ( ! function_exists('plug_shop_rolo_slider') ) {
    /**
     * Modify TBody class if rolo slider is active
     *
     * @since  1.0.0
     *
     * @param array $classes
     *
     * @return array
     */
    function plug_shop_rolo_slider_class($classes) {
        // If Rolo slider is active add class
        if( class_exists('Rolo_Slider') )
            $classes[] = 'rolo-active';

        return $classes;
    }
}

// Add filter on init hook after plugins have been loaded
function plug_shop_plugins_hook() {
    add_filter( 'body_class', 'plug_shop_rolo_slider_class' );
}

add_action( 'init', 'plug_shop_plugins_hook' );


if ( ! function_exists('plug_shop_custom_logo') ) {
    /**
     * Modify logo output.
     *
     * @since  1.0.0
     *
     * @param string $html
     * @param array  $blog_id
     *
     * @return string
     */
    function plug_shop_custom_logo($html, $blog_id) {
        $custom_logo_id = get_theme_mod( 'custom_logo' );
        $display_tagline = get_theme_mod( 'header_text' );

        $plug_shop_logo = '<div class="pf-col-md-4"><div class="logo-wrap">';

        // We have a logo. Logo is go.
        if ( $custom_logo_id && ! $display_tagline ) {
            $plug_shop_logo .= sprintf( '<a href="%1$s" class="logotype-img" rel="home" itemprop="url">%2$s</a>',
                esc_url( home_url( '/' ) ),
                wp_get_attachment_image( $custom_logo_id, 'full', false, array(
                    'class'    => 'custom-logo',
                    'alt'      => 'logo'
                ) )
            );
        } else {
            $plug_shop_logo .= sprintf('<a id="site-title" class="text" href="%1$s" title="2$s" rel="home">%3$s</a>',
                    esc_url( home_url( '/' ) ),
                    esc_attr( get_bloginfo( 'name', 'display' ) ),
                    esc_attr( get_bloginfo( 'name', 'display' ) )
                );
            $plug_shop_logo .= sprintf( '<span class="site-desc">%s</span>' . "\n", get_bloginfo( 'description' ) );
        }

        $plug_shop_logo .= '</div></div>';

        $html = apply_filters ( 'plug_shop_child_logo', $plug_shop_logo);

        return $html;
    }
}
add_filter('get_custom_logo', 'plug_shop_custom_logo', 10, 2);


/**
 * Call a shortcode function by tag name.
 *
 * @since  1.0.0
 *
 * @param string $tag     The shortcode whose function to call.
 * @param array  $atts    The attributes to pass to the shortcode function. Optional.
 * @param array  $content The shortcode's content. Default is null (none).
 *
 * @return string|bool False on failure, the result of the shortcode on success.
 */
function plug_shop_do_shortcode( $tag, array $atts = array(), $content = null ) {
    global $shortcode_tags;

    if ( ! isset( $shortcode_tags[ $tag ] ) ) {
        return false;
    }

    return call_user_func( $shortcode_tags[ $tag ], $atts, $content, $tag );
}