<?php
/**
 * Customizer Inline CSS
 *
 * @package Plug Shop WordPress Theme
 * @subpackage Plug Shop
 * @author Pressfore - www.pressfore.com
 *
 */


if ( !function_exists( 'plug_shop_customizer_styles' ) )
{

	function plug_shop_customizer_styles()
	{

		$theme = wp_get_theme();
		if(is_child_theme()) 
		{
			$parent  = $theme->parent();
			$version = $parent['Version'];
		} 
		else 
		{
			$version = $theme['Version'];
		}

		# Get Typography Options
		$heading_font = '' !== plug_shop_options('heading_font') ? plug_shop_options('heading_font') : plug_shop_customizer_cb('Merriweather');
		$body_font    = '' !== plug_shop_options('main_font') ? plug_shop_options('main_font') : plug_shop_customizer_cb('Open Sans');
		$menu_font    = '' !== plug_shop_options('header_font') ? plug_shop_options('header_font') : plug_shop_customizer_cb('Open Sans') ;

		# Args
		$menu_args    = plug_shop_format_font($menu_font);
		$heading_args = plug_shop_format_font($heading_font);
		$body_args    = plug_shop_format_font($body_font);

		# Get protocol
		$protocol     = is_ssl() ? 'https' : 'http';

		wp_enqueue_style('plug_shop-body-font',add_query_arg($body_args, "$protocol://fonts.googleapis.com/css" ),array(), null);
		wp_enqueue_style('plug_shop-heading-font',add_query_arg($heading_args, "$protocol://fonts.googleapis.com/css" ),array(), null);
		wp_enqueue_style('plug_shop-header-font',add_query_arg($menu_args, "$protocol://fonts.googleapis.com/css" ),array(), null);

		$logo_height			 = plug_shop_options('logo_height', 50);
		$secondary_color   		 = plug_shop_options('secondary_color', '');
		$primary_color     		 = plug_shop_options('primary_color', '#40c4ff');
		$header_bg_color     	 = plug_shop_options('header_bg_color', 'transparent');
		$menu_bg_color     	     = plug_shop_options('menu_bg_color', '#f5f5f5');
		$menu_color     		 = plug_shop_options('menu_1st_color', '#606264');
		$menu_2nd_color     	 = plug_shop_options('menu_2nd_color', '#767676');
		$menu_hcolor     	 	 = plug_shop_options('menu_hcolor', '#40c4ff');
		$body_bg_color     		 = plug_shop_options('body_bg_color', '');
		$footer_bg_top   		 = plug_shop_options('footer_bg_top', '');
		$footer_bg_bottom   	 = plug_shop_options('footer_bg_bottom', '');
		$body_text_color   		 = plug_shop_options('body_text_color', '');
		$heading_color   		 = plug_shop_options('heading_color', '#545454');
		$footer_text_color 		 = plug_shop_options('footer_text_color', '');
		$footer_btext_color 	 = plug_shop_options('footer_btext_color', '');
		$link_color        		 = plug_shop_options('link_color', '');
		$link_hover_color  		 = plug_shop_options('link_hover_color', '');
		$footer_link_color       = plug_shop_options('footer_link_color', '');
		$footer_link_hover_color = plug_shop_options('footer_link_hover_color', '');

		$css = array();

		$css['body'] = sprintf("
			body {
				color: %s;
				font-family: %s;
				background-color: %s;
				font-size: %s;
				line-height: %s;
				letter-spacing: %s;
			}
			",
			esc_attr($body_text_color),
			esc_attr($body_font['font-family']),
			esc_attr($body_bg_color),
			esc_attr($body_font['font-size']),
			esc_attr($body_font['line-height']),
			esc_attr($body_font['letter-spacing'])
		);

		$css['headings'] = sprintf("
				h1,h2,h3,h4,h5,h6 {
					font-family: %s;
					color: %s;
				}
			",
			esc_attr($heading_font['font-family']),
			esc_attr($heading_color)
		);

		$css['header'] = sprintf("
				#header .main-navigation {
					font-family: %s;
				}
				.main-navigation ul {
					text-align: %s;
				}
				.main-navigation .menu  > li > a {
					color: %s;
					letter-spacing: %s;
					text-transform: %s;
					font-size: %s;
					font-weight: %s;
				}
				.plug-shop-cart > a {
					color: %s;
				}
				.main-navigation .menu  .sub-menu > li > a {
					color: %s;
				}
				.main-navigation .menu li:hover > a,
				.main-navigation .menu li.focus > a,
				.main-navigation .menu li.current-menu-item > a,
				.header-right .plug-shop-cart:hover > a,
				.main-navigation .menu .sub-menu>li>a:hover {
					color: %s;
				}
				a#site-title {
					color: %s;
				}
				#header span.site-desc {
					color: %s;
				}
				#header .inner {
					background-color: %s;
				}
				#header .psf-navigation-wrap {
					background-color: %s;
				}
				#header .logo-wrap  img {
					height: %s;
				}
				.nav-collapse b {
					background-color: %s;
				}
				.entry-header:not(.has-title-bg) {
					background-color: %s;
				}
			",
			esc_attr($menu_font['font-family']),
			esc_attr($menu_font['text-align']),
			esc_attr($menu_color),
			esc_attr($menu_font['letter-spacing']),
			esc_attr($menu_font['text-transform']),
			esc_attr($menu_font['font-size']),
			esc_attr($menu_font['variant']),
			esc_attr($menu_color),
			esc_attr($menu_2nd_color),
			esc_attr($menu_hcolor),
			esc_attr($primary_color),
			esc_attr($secondary_color),
			esc_attr($header_bg_color),
			esc_attr($menu_bg_color),
			esc_attr($logo_height) . 'px',
			esc_attr($primary_color),
			esc_attr($body_bg_color)
		);

		$css['links'] = sprintf("
				a,a:visited,
				#sidebar a {
					color: %s;
				}
				a:hover, a:focus, a:active,
				#sidebar a:hover {
					color: %s;
				}
			",
			esc_attr($link_color),
			esc_attr($link_hover_color)
		);

		$css['woocommerce'] = sprintf('
				.woocommerce-Price-amount,
				.widget-container.widget_products ul.product_list_widget li .amount,
				.widget-container.widget_recently_viewed_products ul.product_list_widget li .amount,
				.widget-container.widget_top_rated_products ul.product_list_widget li .amount,
				.widget.widget_products ul.product_list_widget li .amount,
				.widget.widget_recently_viewed_products ul.product_list_widget li .amount,
				.widget.widget_top_rated_products ul.product_list_widget li .amount,
				.woocommerce ul.products li.product .plug-shop-title-wrap .button,
				.woocommerce-message::before,
				.entry-header #breadcrumbs a:not(:last-child)::after,
				.entry-header #breadcrumbs span:not(:last-child)::after {
					color: %1$s;
				}

				.woocommerce ul.products li.product .plug-shop-title-wrap .button:hover {
					color: #333;
				}

				.woocommerce-message,
				.main-navigation .menu .sub-menu {
				    border-top-color: %1$s;
				}

				.woocommerce #respond input#submit.alt,
				.woocommerce #review_form #respond .form-submit input,
				.woocommerce .added_to_cart.wc-forward,
				.woocommerce .button,
				.woocommerce .button.wc-forward,
				.woocommerce a.button,
				.woocommerce a.button.alt,
				.woocommerce button.button.alt,
				.woocommerce input.button,
				.woocommerce input.button.alt,
				.woocommerce.widget_price_filter .ui-slider .ui-slider-range,
				.woocommerce.widget_price_filter .ui-slider .ui-slider-handle,
				.woocommerce.widget_price_filter .price_slider_amount .button,
				.woocommerce-cart .woocommerce #payment div.payment_box,
				.woocommerce-page .woocommerce #payment div.payment_box,
				.comment-form .form-submit input[type="submit"] {
					background-color: %1$s;
				}

				.header-area .plug-shop-cart .widget_shopping_cart_content > p.buttons > a.button.wc-forward {
					border-color: %1$s;
				}
			',
			esc_attr($primary_color)
		);

		$css['footer'] = sprintf("
				#footer {
					background-color: %s;
					color: %s;
				}
				#footer a{
					color: %s;
				}
				#footer a:hover,
				#footer a:visited{
					color: %s;
				}
				#footer #credits {
					background-color: %s;
					color: %s;
				}
			",
			esc_attr($footer_bg_top),
			esc_attr($footer_text_color),
			esc_attr($footer_link_color),
			esc_attr($footer_link_hover_color),
			esc_attr($footer_bg_bottom),
			esc_attr($footer_btext_color)
		);

		$css = apply_filters( 'plug_shop_customizer_style', $css );
		$css = implode( ' ', $css );

		wp_add_inline_style( 'plug-shop', $css );

	}
	add_action( 'wp_enqueue_scripts', 'plug_shop_customizer_styles');

}