<?php
/**
 * Layout Hooks:
 *
 * plug_shop_content_wrap // Opening content wrapper
 * plug_shop_content_wrap_close // Closing content wrapper
 * plug_shop_inner_wrapper_close // close wrapper inner
 * plug_shop_content_width // Set content width
 * plug_shop_display_thumbnail // Featured image size
 * plug_shop_body_class_filter // Body classes
 * plug_shop_post_class_filter // Post Classes
 * plug_shop_post_layout // Apply post layout featured image
 * plug_shop_custom_pagenav // Custom post navigation markup
 * plug_shop_blog_navigation // Blog navigation
 * plug_shop_deregister_styles // deregister pagenavi default styles
 * remove_more_jump_link // remove read more jump
 * plug_shop_remove_wpautop // remove wpautop
 *
 * For more information on hooks, actions, and filters, see http://codex.wordpress.org/Plugin_API.
 *
 * @package WordPress
 * @subpackage Plug Shop
 * @since 1.0.0
 *
 */


/*-----------------------------------------------------------------------------------*/
// Content Wrap Markup - plug_shop_content_wrap()
// Be sure to add the excess of 16 to plug_shop_before_sidebar() as well
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'plug_shop_content_wrap' ) )  {

	function plug_shop_content_wrap() {

		$columns = '';
		$columns = apply_filters('plug_shop_set_colwidth', $columns, 1);

		echo '<div class="wrapper-inner pf-row clearfix">';
		printf( '<div id="content" class="pf-col-12 %s">', esc_attr($columns) );

	}

	add_action( 'plug_shop_before_content', 'plug_shop_content_wrap', 1 );
}


/*-----------------------------------------------------------------------------------*/
// After Content Wrap Markup - plug_shop_content_wrap_close()
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists('plug_shop_content_wrap_close') ) {

    function plug_shop_content_wrap_close() {
    	echo "\t\t</div><!-- /.columns (#content) -->\n";
    }

    add_action( 'plug_shop_after_content', 'plug_shop_content_wrap_close', 1 );
}

/*-----------------------------------------------------------------------------------*/
// Close wrap inner container - plug_shop_inner_wrapper_close()
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists('plug_shop_inner_wrapper_close') ) {

    function plug_shop_inner_wrapper_close() {
    	echo "\t\t</div><!-- /.wrapper-inner -->\n";
		echo '<a id="top"></a>';
    }

    add_action( 'plug_shop_footer', 'plug_shop_inner_wrapper_close', 9 );
}

if ( ! function_exists( 'plug_shop_content_width' ) ) {
	/**
	 * Filterable utility function to set the content width - plug_shop_content_width()
	 * Specifies the column classes via conditional statements
	 * See http://codex.wordpress.org/Conditional_Tags for a full list
	 *
	 * @return string
	 * @since  1.0.0
	 */
	function plug_shop_content_width() {
		global $post;
		$sidebar = plug_shop_options('sidebar_width', '3');
		$layout  = plug_shop_options('shop_layout', 'sidebar');
		$columns = 12 - (int)$sidebar;

		if ( is_single() && ! is_singular( 'product' ) ) { // Single Posts.
			$post_type = get_post_type();
			$post_wide = get_post_meta($post->ID, 'sidebars', $single = true) ==  "false";

			if ( ! is_active_sidebar('sidebar-1') || $post_wide || 'wpf-portfolio' === $post_type ) {
				$columns = '12';
			}

			// wide attachement pages.
			if ( is_attachment() ) {
				$columns = '12';
			}


		} elseif ( plug_shop_is_wc_template() ) {

			if ( 'full' === $layout ) {
				$columns = '12';
			}
		} elseif ( is_page() ) { // Single Pages.
			$page_sidebar = is_page_template( array( 'templates/page-sidebar.php', 'templates/dynamic.php', 'templates/homepage-sidebar.php' ) );

			// make sure no Page widgets are active.
			if ( ! $page_sidebar ) {
				$columns = '12';
			}
		}

		return sprintf('pf-col-lg-%s', esc_attr( $columns ) );

	}

	add_filter('plug_shop_set_colwidth', 'plug_shop_content_width', 10, 1);
}

if ( ! function_exists( 'plug_shop_display_thumbnail' ) ) {
	/**
	 * Featured Images
	 *
	 * @since  1.0.0
	 */
	function plug_shop_display_thumbnail($custom_size = 'post-thumbnail') {
		$thumbnail = plug_shop_get_thumbnail($custom_size);

		echo wp_kses($thumbnail, array(
			'a'   => array(
				'class' => true,
				'href'  => true
			),
			'img' => array(
				'src'   => true,
				'class' => true,
				'alt'   => true
			)
		));
	}

	add_action('plug_shop_post_thumbnail','plug_shop_display_thumbnail');
}


if ( ! function_exists( 'plug_shop_body_class_filter' ) ) {
	/**
	 * Filters the WordPress body class with a better set of classes
	 *
	 * @param  array        $classes
	 * @param  string|array $class
	 * @return array
	 * @since  1.0.0
	 */
	function plug_shop_body_class_filter( $classes, $class ) {

		$classes[] = 'pf-body';

		// Text direction.
		$classes[] = is_rtl() ? 'rtl' : 'ltr';

		// Check if the current theme is a parent or child theme.
		$classes[] = is_child_theme() ? 'child-theme' : 'parent-theme';

		// Layout
		$classes[] = 'layout-' . plug_shop_options('layout', '1200');

		if( is_home() || is_page_template('templates/dynamic.php') || is_author() || is_archive() || is_tag() ) {
			$classes[] = 'blog';
		}

		// Multisite check adds the 'multisite' class and the blog ID.
		if ( is_multisite() ) {
			$classes[] = 'multisite';
			$classes[] = 'blog-' . get_current_blog_id();
		}

		// Is the current user logged in.
		$classes[] = is_user_logged_in() ? 'logged-in' : 'logged-out';

		// Use the '.custom-background' class to integrate with the WP background feature.
		if ( get_background_image() || get_background_color() ) {
			$classes[] = 'custom-background';
		}

		// Add the '.custom-header' class if the user is using a custom header.
		if ( get_header_image() || ( display_header_text() && get_header_textcolor() ) ) {
			$classes[] = 'custom-header';
		}

		// Add the '.display-header-text' class if the user chose to display it.
		if ( display_header_text() ) {
			$classes[] = 'display-header-text';
		}

		// Singular post (post_type) classes.
		if ( is_singular() ) {

			// Get the queried post object.
			$post = get_queried_object();

			// Post format.
			if ( current_theme_supports( 'post-formats' ) && post_type_supports( $post->post_type, 'post-formats' ) ) {
				$post_format = get_post_format( get_queried_object_id() );
				$classes[] = $post_format || is_wp_error( $post_format ) ? "{$post->post_type}-format-standard" : "{$post->post_type}-format-{$post_format}";
			}

			// Attachment mime types.
			if ( is_attachment() ) {

				foreach ( explode( '/', get_post_mime_type() ) as $type ) {
					$classes[] = "attachment-{$type}";
				}
			}
		}

		// Add full width class if full width.
		// page is used.
		if( is_page_template('templates/page-full.php') ) {
			$classes[] = 'full-width-template';
		}

		// Add parent theme version.
		$theme = wp_get_theme();
		if ( is_child_theme() ) {
			$parent  = $theme->parent();
			$version = $parent['Version'];
		} else {
			$version = $theme['Version'];
		}

		$classes[] = str_replace(' ', '-', $theme).'-'.$version;

		// Paged views.
		if ( is_paged() ) {
			$classes[] = 'paged';
			$classes[] = 'paged-' . intval( get_query_var( 'paged' ) );
		}

		// Singular post paged views using <!-- nextpage -->.
		elseif ( is_singular() && 1 < get_query_var( 'page' ) ) {
			$classes[] = 'paged';
			$classes[] = 'paged-' . intval( get_query_var( 'page' ) );
		}

		// Input class.
		if ( $class ) {
			$class   = is_array( $class ) ? $class : preg_split( '#\s+#', $class );
			$classes = array_merge( $classes, $class );
		}

		return array_map( 'esc_attr', $classes );
	}

	add_filter( 'body_class', 'plug_shop_body_class_filter', 0, 2 );
}

if ( !function_exists( 'plug_shop_post_class_filter' ) ) {
	/**
	 * Filters the WordPress post class with additional classes
	 *
	 * @param  array        $classes
	 * @param  string|array $class
	 * @param  int          $post_id
	 * @return array
	 * @since  1.0.0
	 */
	function plug_shop_post_class_filter( $classes, $class, $post_id ) {

		if ( is_admin() )
			return $classes;

		$_classes    = array();
		$post        = get_post( $post_id );
		$post_type   = get_post_type();

		if ( post_type_supports( $post_type, 'post-formats' ) ) {
			$remove[] = 'post_format-post-format-' . get_post_format();
		}

		// Post layout
		$_classes[] = plug_shop_options('post_layout', 'layout-1');

		// Check for dynamic post on dynamic page template
		if( $post_type !== 'post' ) {
			$_classes[] = 'dynamic-post';
		}

		// Author class.
		$_classes[] = 'author-' . sanitize_html_class( get_the_author_meta( 'user_nicename' ), get_the_author_meta( 'ID' ) );

		// Password-protected posts.
		if ( post_password_required() ) {
			$_classes[] = 'protected';
		}

		// Has excerpt.
		if ( post_type_supports( $post_type, 'excerpt' ) && has_excerpt() ) {
			$_classes[] = 'has-excerpt';
		}

		// Has <!--more--> link.
		if ( ! is_singular() && false !== strpos( $post->post_content, '<!--more' ) ) {
			$_classes[] = 'has-more-link';
		}

		// Has <!--nextpage--> links.
		if ( false !== strpos( $post->post_content, '<!--nextpage' ) ) {
			$_classes[] = 'has-pages';
		}

		return array_map( 'esc_attr', array_unique( array_merge( $_classes, $classes ) ) );
	}

	add_filter( 'post_class', 'plug_shop_post_class_filter', 0, 3 );
}

if ( ! function_exists( 'plug_shop_post_layout' ) ) {
	/**
	 * Post layout - apply image size depending from layout selected
	 *
	 * @since  1.0.0
	 */
	function plug_shop_post_layout($image_size) {
		$crop = plug_shop_options('crop_thumb', 'no');

		if( ! is_page() && ! is_home() ) {
			$layout = plug_shop_options('post_layout', 'layout-1');
			$image_size = 'full';

			if( 'layout-2' == $layout ) {
				$image_size = 'post-thumbnail';
			}
		}
		
		if( ( is_home() || is_page_template('templates/dynamic.php') ) && 'full' == $crop )	{
			$image_size = 'full';
		}

		return esc_attr( $image_size );
	}

	add_filter('plug_shop_thumbnail_size','plug_shop_post_layout');
}

if ( ! function_exists( 'plug_shop_custom_pagenav' ) ) {
	/**
	 * Custom Page Navigation
	 *
	 * @since  1.0.0
	 */
	function plug_shop_custom_pagenav($args = array()) {

			if ( function_exists( 'wp_pagenavi' ) ) {

				if (is_page() && !is_page_template('templates/dynamic.php')) {
					wp_pagenavi( array(
							'type'   => 'multipart' ,
							'before' => '<div id="nav-below" class="navigation">',
							'after'  => '</div>'
					) );

				}  elseif (is_single() && 'wpf-portfolio' == get_post_type() ) {
					echo '<div id="nav-below" class="navigation">';
						previous_post_link( '<div class="nav-prev">%link</div>', esc_html__( 'Previous Portfolio', 'plug-shop' ) );
						next_post_link( '<div class="nav-next">%link</div>', esc_html__( 'Next Portfolio', 'plug-shop' ) );
					echo '</div><!-- #nav-below -->';

				} elseif (is_single()) {
					echo '<div id="nav-below" class="navigation">';
						previous_post_link( '<div class="nav-prev">%link</div>', esc_html__( 'Previous Post', 'plug-shop' ) );
						next_post_link( '<div class="nav-next">%link</div>', esc_html__( 'Next Post', 'plug-shop' ) );
					echo '</div><!-- #nav-below -->';

				} else {
					echo '<div id="nav-below" class="navigation">';
						wp_pagenavi($args);
					echo '</div><!-- #nav-below -->';
				}

			} else {

				if (is_page()) {
						wp_link_pages( array( 'before' => '<div id="nav-below" class="navigation"><div class="page-link">' . esc_html__( 'Pages:', 'plug-shop' ), 'after' => '</div></div>' ) );

				} elseif (is_single() && 'wpf-portfolio' == get_post_type() ) {
					echo '<div id="nav-below" class="navigation">';
						previous_post_link( '<div class="nav-prev">%link</div>', esc_html__( 'Previous Portfolio', 'plug-shop' ) );
						next_post_link( '<div class="nav-next">%link</div>', esc_html__( 'Next Portfolio', 'plug-shop' ) );
					echo '</div><!-- #nav-below -->';

				} elseif (is_single()) {
					echo '<div id="nav-below" class="navigation">';
						previous_post_link( '<div class="nav-prev">%link</div>', esc_html__( 'Previous Post', 'plug-shop' ) );
						next_post_link( '<div class="nav-next">%link</div>', esc_html__( 'Next Post', 'plug-shop' ) );
					echo '</div><!-- #nav-below -->';

				} else {
					echo '<div id="nav-below" class="navigation">';

						if( isset($args['query']) ) {
							echo '<div id="nav-below" class="navigation">';
								$query = $args['query'];
								next_posts_link( sprintf( '<div class="nav-next">%s</div>', esc_html__( 'Older posts', 'plug-shop' ) ), $query->max_num_pages );
						} else {
							next_posts_link( sprintf( '<div class="nav-next">%s</div>', esc_html__( 'Older posts', 'plug-shop' ) ) );
						}

						previous_posts_link( sprintf( '<div class="nav-prev">%s</div>', esc_html__( 'Newer posts', 'plug-shop' ) ) );
					echo '</div><!-- #nav-below -->';
				}
			}
	}

	add_action('plug_shop_page_navi','plug_shop_custom_pagenav');
}

if ( ! function_exists( 'plug_shop_blog_navigation' ) ) {

	function plug_shop_blog_navigation() {
		/* Display navigation to next/previous pages when applicable */
		global $wp_query;
		$query = $wp_query;
		$args = array();

		$is_dynamic = is_page_template('templates/dynamic.php');

		if( isset($GLOBALS['plug_shop_query']) ) {
			global $plug_shop_query;
			$query = $plug_shop_query;

			$args['type'] = $query->query['post_type'];
			$args['query'] = $query;
		}

		if ( ( $query->max_num_pages > 1 && $is_dynamic ) || ( $query->max_num_pages > 1 && !plug_shop_is_wc_template() ) ) {
			do_action('plug_shop_page_navi', $args);
		}
	}

	add_action('plug_shop_footer', 'plug_shop_blog_navigation', 10);
}

/**
 * -----------------------------------------------------------------------------
 * Remove WP Pagenavi Styles
 * Theme Includes Native Supportters the WordPress post class with additional classes
 *
 * @since  1.0.0
 */
function plug_shop_deregister_styles() {
	wp_deregister_style( 'wp-pagenavi' );
}

add_action( 'wp_enqueue_scripts', 'plug_shop_deregister_styles', 100 );

if ( ! function_exists( 'plug_shop_remove_more_jump_link' ) ) {
	/**
	 * -----------------------------------------------------------------------------
	 * Removes the page jump when read more is clicked through
	 *
	 * @since  1.0.0
	 */
	function plug_shop_remove_more_jump_link($link) {
		$offset = strpos($link, '#more-');

		if ( $offset ) {
			$end = strpos($link, '"',$offset);
		}

		if ( $end ) {
			$link = substr_replace($link, '', $offset, $end-$offset);
		}

		return $link;
	}

	add_filter('the_content_more_link', 'plug_shop_remove_more_jump_link');
}


/*-----------------------------------------------------------------------------------*/
/* Override default embeddable content width
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists('plug_shop_content_width') ) {

	function plug_shop_content_width() {
		$content_width = 580;
	}
}