<?php

/**
 * Sample implementation of the Custom Header feature
 *
 * @link https://developer.wordpress.org/block-editor/developers/block-api/block-patterns/
 *
 * @package pliska
 */
/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {
	function prespa_pattern_setup() {
		register_block_pattern_category(
			'pliska',
			array(
				'label' => esc_html__( 'Pliska', 'pliska' ),
			)
		);
	}
	add_action( 'after_setup_theme', 'prespa_pattern_setup' );
}

/**
 * Create custom block patterns to complement the theme.
 */

if ( function_exists( 'register_block_pattern' ) ) {
	function pliska_register_block_patterns() {
		if ( class_exists( 'WP_Block_Patterns_Registry' ) ) {
			register_block_pattern(
				'pliska/full-width-banner-1',
				array(
					'title'       => __( 'Fullwidth Header Banner One', 'pliska' ),
					'description' => __( 'Fullwidth Banner that can be used as a custom page header', 'pliska' ),
					'content'     => "<!-- wp:cover {\"url\":\" ". esc_url( get_template_directory_uri() ) . "/assets/img/2000X1333.jpg\",\"id\":1836,\"hasParallax\":true,\"align\":\"full\",\"className\":\"section-fullwidth\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim has-parallax section-fullwidth\" style=\"background-image:url(" . esc_url( get_template_directory_uri() ) . "/assets/img/2000X1333.jpg)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"placeholder\":\"Write title…\",\"fontSize\":\"large\"} -->\n<p class=\"has-text-align-center has-large-font-size\">Extraordinary Advice for Extraordinary Business</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Lorem ipsum dolor sit amet.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\",\"className\":\"is-content-justification-center\"} -->\n<div class=\"wp-block-buttons aligncenter is-content-justification-center\"><!-- wp:button {\"borderRadius\":5,\"textColor\":\"white\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-color has-text-color\" style=\"border-radius:5px\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:cover -->",
					'categories'  => array( 'pliska' ),
				)
			);
			register_block_pattern(
				'pliska/full-width-banner-2',
				array(
					'title'       => __( 'Fullwidth Header Banner Two', 'pliska' ),
					'description' => __( 'Fullwidth Banner that can be used as a custom page header', 'pliska' ),
					'content'     => "<!-- wp:group {\"align\":\"full\",\"className\":\"is-swap-on-mobile section-fullwidth-2\"} -->\n<div class=\"wp-block-group alignfull is-swap-on-mobile section-fullwidth-2\"><div class=\"wp-block-group__inner-container\"><!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":50} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading -->\n<h2>Create New Opportunities</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Curabitur placerat posuere gravida. Donec facilisis dolor risus, id posuere urna ullamcorper vitae. Cras porta posuere lacus non scelerisque. Duis faucibus magna et ipsum hendrerit sagittis. Praesent nunc odio, tincidunt nec hendrerit vitae, pretium sit amet libero. Praesent vitae enim faucibus, ultricies mi a, sagittis augue. In ultrices lobortis eros, faucibus egestas sem sollicitudin in. Aenean venenatis facilisis nisl ac tristique. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quisque non leo eu purus rhoncus maximus ut non nunc. Nulla sit amet bibendum metus. Morbi elit metus, interdum eleifend eros ac, tristique suscipit orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":5,\"textColor\":\"green\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-green-color has-text-color\" style=\"border-radius:5px\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":50} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:image {\"id\":12,\"width\":600,\"height\":450,\"sizeSlug\":\"full\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-resized is-style-default\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/assets/img/patterns/bridge.jpg\" alt=\"bridge\" class=\"wp-image-12\" width=\"600\" height=\"450\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:group -->",
					'categories'  => array( 'pliska' ),
				)
			);
			register_block_pattern(
				'pliska/about-page',
				array(
					'title'       => __( 'About Page', 'pliska' ),
					'description' => __( 'An example about us page', 'pliska' ),
					'content'     => "<!-- wp:group {\"align\":\"full\",\"className\":\"is-swap-on-mobile about-page\"} -->\n<div class=\"wp-block-group alignfull is-swap-on-mobile about-page\"><div class=\"wp-block-group__inner-container\"><!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":50} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading -->\n<h2>About Us</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Lorem Ipsum has been around since 1500s. It is a nonsensical text with only one purpose - to outline the visual elements of a document or presentation, eg typography, font, or layout.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>It is a convenient tool for mock-ups. It helps to outline the visual elements of a document or presentation, eg typography, font, or layout. Lorem ipsum is mostly a part of a Latin text by the classical author and philosopher Cicero. Its words and letters have been changed by addition or removal, so to deliberately render its content nonsensical; it is not genuine, correct, or comprehensible Latin anymore.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> These days there are online lorem ipsum generators that will help you generate lorem ipsum content in seconds. If you are still following, look at the below text to see how lorem ipsum actually looks like.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Viverra ipsum nunc aliquet bibendum enim facilisis gravida neque. Lobortis scelerisque fermentum dui faucibus in ornare quam viverra. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Nisl vel pretium lectus quam. Eu ultrices vitae auctor eu augue ut lectus arcu bibendum. Vitae et leo duis ut diam quam nulla. Fames ac turpis egestas integer.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Cras volutpat, lacus quis semper pharetra, nisi enim dignissim est, et sollicitudin quam ipsum vel mi. Sed commodo urna ac urna. Nullam eu tortor.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":5,\"textColor\":\"green\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-green-color has-text-color\" style=\"border-radius:5px\">Contact Us</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":50} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:image {\"id\":29,\"width\":692,\"height\":860,\"sizeSlug\":\"full\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-resized is-style-default\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/assets/img/patterns/compass.jpg\" alt=\"\" class=\"wp-image-29\" width=\"692\" height=\"860\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:group -->",
					'categories'  => array( 'pliska' ),
				)
			);
			register_block_pattern(
				'pliska/services-4-items',
				array(
					'title'       => __( 'Services Page', 'pliska' ),
					'description' => __( 'A Services block with a main header and 3 services', 'pliska' ),
					'content'     => "<!-- wp:group {\"align\":\"full\",\"className\":\"is-swap-on-mobile services-page\",\"style\":{\"color\":{\"background\":\"#f5f5f5\"}}} -->\n<div class=\"wp-block-group alignfull is-swap-on-mobile services-page has-background\" style=\"background-color:#f5f5f5\"><div class=\"wp-block-group__inner-container\"><!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2>Title #1</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Curabitur placerat posuere gravida. Donec facilisis dolor risus, id posuere urna ullamcorper vitae. Cras porta posuere lacus non scelerisque. Duis faucibus magna et ipsum hendrerit sagittis. Praesent nunc odio, tincidunt nec hendrerit vitae, pretium sit amet libero. Praesent vitae enim faucibus, ultricies mi a, sagittis augue. In ultrices lobortis eros, faucibus egestas sem sollicitudin in. Aenean venenatis facilisis nisl ac tristique. Etiam nec malesupliska libero.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quisque non leo eu purus rhoncus maximus ut non nunc. Nulla sit amet bibendum metus. Morbi elit metus, interdum eleifend eros ac, tristique suscipit orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":5,\"textColor\":\"green\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-green-color has-text-color\" style=\"border-radius:5px\">Read more</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":12,\"width\":600,\"height\":450,\"sizeSlug\":\"full\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-resized is-style-default\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/assets/img/patterns/bridge.jpg\" alt=\"bridge\" class=\"wp-image-12\" width=\"600\" height=\"450\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":12,\"sizeSlug\":\"full\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/assets/img/patterns/bridge.jpg\" alt=\"bridge\" class=\"wp-image-12\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2>Title #2</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Curabitur placerat posuere gravida. Donec facilisis dolor risus, id posuere urna ullamcorper vitae. Cras porta posuere lacus non scelerisque. Duis faucibus magna et ipsum hendrerit sagittis. Praesent nunc odio, tincidunt nec hendrerit vitae, pretium sit amet libero. Praesent vitae enim faucibus, ultricies mi a, sagittis augue. In ultrices lobortis eros, faucibus egestas sem sollicitudin in. Aenean venenatis facilisis nisl ac tristique. Etiam nec malesupliska libero.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quisque non leo eu purus rhoncus maximus ut non nunc. Nulla sit amet bibendum metus. Morbi elit metus, interdum eleifend eros ac, tristique suscipit orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":5,\"textColor\":\"green\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-green-color has-text-color\" style=\"border-radius:5px\">Read more</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2>Title #3</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Curabitur placerat posuere gravida. Donec facilisis dolor risus, id posuere urna ullamcorper vitae. Cras porta posuere lacus non scelerisque. Duis faucibus magna et ipsum hendrerit sagittis. Praesent nunc odio, tincidunt nec hendrerit vitae, pretium sit amet libero. Praesent vitae enim faucibus, ultricies mi a, sagittis augue. In ultrices lobortis eros, faucibus egestas sem sollicitudin in. Aenean venenatis facilisis nisl ac tristique. Etiam nec malesupliska libero.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quisque non leo eu purus rhoncus maximus ut non nunc. Nulla sit amet bibendum metus. Morbi elit metus, interdum eleifend eros ac, tristique suscipit orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":5,\"textColor\":\"green\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-green-color has-text-color\" style=\"border-radius:5px\">Read more</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":12,\"width\":600,\"height\":450,\"sizeSlug\":\"full\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-resized is-style-default\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/assets/img/patterns/bridge.jpg\" alt=\"bridge\" class=\"wp-image-12\" width=\"600\" height=\"450\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":12,\"width\":600,\"height\":450,\"sizeSlug\":\"full\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-resized is-style-default\"><img src=\"" . esc_url( get_template_directory_uri() ) . "/assets/img/patterns/bridge.jpg\" alt=\"bridge\" class=\"wp-image-12\" width=\"600\" height=\"450\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2>Title #4</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Curabitur placerat posuere gravida. Donec facilisis dolor risus, id posuere urna ullamcorper vitae. Cras porta posuere lacus non scelerisque. Duis faucibus magna et ipsum hendrerit sagittis. Praesent nunc odio, tincidunt nec hendrerit vitae, pretium sit amet libero. Praesent vitae enim faucibus, ultricies mi a, sagittis augue. In ultrices lobortis eros, faucibus egestas sem sollicitudin in. Aenean venenatis facilisis nisl ac tristique. Etiam nec malesupliska libero.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Quisque non leo eu purus rhoncus maximus ut non nunc. Nulla sit amet bibendum metus. Morbi elit metus, interdum eleifend eros ac, tristique suscipit orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":5,\"textColor\":\"green\",\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-green-color has-text-color\" style=\"border-radius:5px\">Read more</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:group -->",
					'categories'  => array( 'pliska' ),
				)
			);
			register_block_pattern(
				'pliska/recent-posts',
				array(
					'title'       => __( 'Recent Posts', 'pliska' ),
					'description' => __( 'Call to action on Homepage', 'pliska' ),
					'content'     => "<!-- wp:group {\"className\":\"section-latest-posts\"} -->\n<div class=\"wp-block-group section-latest-posts\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"has-text-align-center\">Latest Posts</h2>\n<!-- /wp:heading -->\n\n<!-- wp:separator {\"color\":\"yellow\",\"className\":\"is-style-default\"} -->\n<hr class=\"wp-block-separator has-text-color has-background has-yellow-background-color has-yellow-color is-style-default\"/>\n<!-- /wp:separator -->\n\n<!-- wp:latest-posts {\"postsToShow\":6,\"displayPostDate\":true,\"postLayout\":\"grid\",\"displayFeaturedImage\":true,\"featuredImageSizeSlug\":\"medium\",\"addLinkToFeaturedImage\":true} /--></div></div>\n<!-- /wp:group -->",
					'categories'  => array( 'pliska' ),
				)
			);
		}

	}

	add_action( 'init', 'pliska_register_block_patterns' );
}
