Pliska
===

Table of Contents
- [Pliska](#pliska)
- [Theme Documentation](#theme-documentation)
  * [Installation](#installation)
  * [Theme Options](#theme-options)
    + [Site identity](#site-identity)
    + [Colors](#colors)
    + [Header Image](#header-image)
    + [Background Image](#background-image)
    + [Widgets](#widgets)
    + [Menus](#menus)
    + [Homepage Settings](#homepage-settings)
    + [Header Options](#header-options)
      - [Header Menu Options](#header-menu-options)
      - [Header Image Options](#header-image-options)
      - [Call to Action Buttons](#call-to-action-buttons)
      - [Header Animations](#header-animations)
    + [Post Settings](#post-settings)
    + [Page Layout](#page-layout)
    + [Night Mode](#night-mode)
    + [Social icons](#social-icons)
    + [Fonts](#fonts)
    + [Footer Options](#footer-options)
    + [Additional CSS](#additional-css)
  * [Premium features](#premium-features)
  * [Child theme](#child-theme)
- [License](#license)

Pliska is a beautiful, next-generation WordPress theme with powerful theme options. It is designed for creating high quality blogs, multi-author publishing platforms, portfolio and company websites. It is fully customizable, with lots of features, looks great and behaves flowlessly on any device, screen size and browser. This modern theme features ready-to-use block patterns, with which you can create your new website in minutes. The theme is optimized for speed and SEO. It features Schema.org markup and is WCAG 2.0 (Level AA) compliant. Make your site truely unique with three different page layouts, different header options, Google fonts and take advantage of all the other awesome free features such as social share for posts, author box, related posts, different menu positions and mega menu functionality. Another awesome feature is that site visitors can switch between light and dark theme mode with a single click. The theme is fully compatible with Gutenberg but also supports the good old classic editor. It also provides a seemless integration with all the popular page builders. Support for WooCommerce and popular WordPress plugins is also fully guarantied. Enjoy this high quality WordPress theme, its first-class user experience, neat documentation, friendly support and generous options to make your content stand out.

Pliska has just enough theme options to make your own unique site without any coding skills. In fact, its theme customizer offers much more options than most of the other free themes in the market:

- 3 different header menu positions (sticky, fixed and normal)
- custom header image
- options to change header image height and position
- options to add image overlay, gradient and parallax effect to the header image
- header image animation
- 3 different header text animations
- customizable 2 call to action buttons on homepage
- custom logo
- custom site icon
- custom header menu
- nested dropdown submenus
- mega menu for very long dropdowns
- custom social icons footer menu
- keyboard navigation
- static homepage
- beautiful svg icons
- light and dark theme mode switch
- light and dark skin
- option to choose default theme mode and disable dark mode
- change theme accent colors, headings, links and buttons
- 1000+ Google Fonts
- choose between 3 different page layouts (left sidebar, right sidebar and fullwidth) and customize per page template
- prebuilt block patterns wih demo content (fullwidth section, header, about page, services page and recent posts)
- 3 different header menu positions (sticky, fixed and normal)
- beautiful pagination
- simple breadcrumbs
- toggle post meta information (post author, post date, post categories, tags and post comments)
- related posts below post content
- post sharing system
- post author box
- add custom widgets to right sidebar and footer
- additional woocommerce sidebar
- responsive design on tablets and mobile
- translation ready
- beginner-friendly
- developer-friendly
- lightweight (no bootstrap, no jquery, no additional font libraries)

# Theme Documentation
## Installation
1. In your admin panel, go to Appearance -> Themes and click the 'Add New' button.
2. Type in Pliska in the search form and press the 'Enter' key on your keyboard.
3. Click on the 'Activate' button to use your new theme right away.
4. Navigate to Appearance > Customize in your admin panel and customize to taste.

## Theme Options
Use the theme customizer to customize the theme to taste. There are plenty of options to make your site unique. You can change theme accent colors, the header text color, the headings text color, the links text color, the call to action buttons on the homepage and much more. 

To use the theme's customizer log in to your dashboard and navigate to Appearance > Customize. You can also access the customizer directly from the admin bar on the top of the page. Now, let's have a look at the theme options in more detail.

### Site identity

* **Upload logo** - you have the option to upload custom logo that will display in the site's header. 

* **Change Site Title & Tagline** - you have the option to add a site's name and description

* **Site Icon** - you have the option to change the site icon in the browser tab (the tab icon at the top part of your browser)
### Colors
Change the colors of the light theme such as the header, the headings, the links, the buttons and the menu text items. Control primary and secondary accent colors, as well as the header image gradient overlay colors.

### Header Image
Pliska supports the option to add custom header image via the theme customizer. Go to Appearance > Customize > Header Image and upload a header image from your PC. The recommended image size is 2000X1200px. You have the options to crop the image (top, bottom or center) or to use the whole image (in this case it should center vertically). As a general recommendation, I would suggest to always compress the images that you upload, otherwise the site performace may deteriorate with time. Read more about that [here](https://rawinfopages.co.uk/squash-images-with-squoosh-to-improve-website-performance/).

### Background Image
Upload a background image that will display throughout the whole website.

### Widgets
Widgets are something very useful if you want to display dynamic info such as latest posts, latest comments or post archives on the website. Pliska theme supports two places to add widgets: the right sidebar and the footer. If you have chosen full-width layout, you will be able to add widgets in the footer only. This theme works best if you add just one widget in "Footer 1" and two widgets in "Footer 2". In the "Right Sidebar" widget you can add as many widgets as you want.

### Menus
This theme supports one menu location - The Primary menu.

* **Menu 1** - You can create the primary menu from the theme customizer or you can also go to dashboard > menu. Click on create menu and give it a name, then drag or add the pages you want to it. After that, from the menu locations section, select Top Menu checkbox. This theme supports as many sub-menus as you want.

### Homepage Settings
Optionally specify a static front page.

### Header Options
The header options tab in the theme customizer consists of four sections: 
- header menu options 
- header image options
- call to action buttons
- header animations

#### Header Menu Options
Customize the top menu bar. Show it only on top of the page (static position), show it, while scrolling down (fixed) or show it when you scroll up (sticky). The default positon is sticky.
#### Header Image Options
You can choose to show the header image on all posts and pages without a featured image or show it on homepage and post archives only. You can also change the image position, change the image height, display paralax effect, add opacity overlay and two-color gradient overlay. You can also toggle the header arrow icon.

#### Call to Action Buttons
The call to action buttons are located on the header of the homepage. You can change the url and the text of the buttons from the Call to Action Buttons section in the Header Options tab in the theme customizer. You can also hide the buttons if you leave any of the two fields empty.

#### Header Animations
Choose between 3 different types of header text animations on page load or remove the animation completely - it is up to you to decide!

### Post Settings
Choose what type of post information to show in the post archives or individual blog posts. The post meta information includes published date, author, category tags or comments. You can display or remove this information if you want. You can also enable or disable breadcrumbs. Breadcrumbs are shown on single posts/pages only and can improve user experience by making it easier for your readers to navigate on the website. You can also toggle related posts section, the author box, the post rating system and the post share icons, located below the post content of the single blog post.
### Page Layout
Choose between page layout with right sidebar, left sidebar or full-width layout with a single click.

### Night Mode
Protect your visitors' eyes and help them spend more time on your website by allowing them to switch between day and night mode (light and dark layout). To change to dark mode, you just need to click on the toggle button in the theme footer. You can change the background color and add custom css to further customize the colors of the night mode. For example, if you want to change the link colors, you can use the following css:

    body.dark-mode a {
	    color: rgba(102, 222, 209, .8) !important;
    }

There is more, you also have the option to switch default modes and display the dark layout by default. If you want, you can also disable the dark mode switch completely - it is completely up to you!

### Social icons
Add social icons in the site footer. Just visit the social media site, go to your user's profile, copy the url from the browser's address bar and paste it in the corresponding field. The social icons will appear automatically.

### Fonts
Choose between 1000+ Google Fonts to make your website unique. Choose different fonts for the headings and for the body. Control font sizes of html elements.

### Footer Options
Change footer text color, footer background color, links and edit footer credits.

### Additional CSS
This section is for more advanced users who want to write custom css to override the default theme's styles.

## Premium features
The premium version offers many more features including 7 additional block patterns (testimonials, partners, stats counter, portfolio items, call to action and 2 custom fullwidth headers), 1000+ Google fonts, various footer options and many other awesome features, such as the option to import a pre-built [demo site](https://try-pliska.nasiothemes.com/) with just a single click! Watch the video guide to find out more!

## Child theme
If you want to customise Pliska beyond the included options, I strongly recommend that you do so via a [child theme](https://developer.wordpress.org/themes/advanced-topics/child-themes/).

# License
* License: [GNU General Public License v2.0](http://www.gnu.org/licenses/gpl-2.0.html)

Happy blogging!