<?php
//OPTIONS

function plied_theme_info_menu() {

	add_theme_page( 
		esc_html__('Welcome To Plied WordPress Theme', 'plied'), 
		esc_html__('Plied Theme Info', 'plied'), 
		'manage_options', 
		'plied_theme_info_options', 
		'plied_theme_info_display' 
	);

}


add_action( 'admin_menu', 'plied_theme_info_menu' );



function plied_theme_info_display() {
	if ( !current_user_can( 'manage_options' ) )  {
		wp_die( esc_html_e( 'You do not have sufficient permissions to access this page.', 'plied' ) );
	}
	
	?>
	<div class="wrap plied-adm">
		<h1 class="header-welcome"><?php esc_html_e('Welcome to Plied - 0.2.5', 'plied'); ?></h1>
		<div class="plied-adm-dsply-fl plied-adm-fl-wrap plied-adm-jc-sp-btw">

			<div class="plied-adm-wid-49 theme-para theme-doc plied-adm-mobwid-100">
				<h4><?php esc_html_e('Theme Documentation','plied'); ?></h4>
				<p><?php esc_html_e('Documentation for this theme includes all theme information that is needed to get your site up and running', 'plied'); ?></p>
				<p>
					<a href="<?php echo esc_url('https://zidithemes.com/plied/'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Theme Documentation', 'plied'); ?>
					</a>
				</p>
			</div>

			<div class="plied-adm-wid-49 theme-para theme-opt plied-adm-mobwid-100">
				<h4><?php esc_html_e('Plied Pro','plied'); ?></h4>
				<p class="">
					<?php esc_html_e('Plied Pro includes portfolio page templates, additional features and more options to customize your website.',  'plied'); ?>
				</p>
				<p>
					<a href="<?php echo esc_url('https://zidithemes.com/plied-pro/'); ?>" class="button button-primary" target="_blank">
						<?php esc_html_e('Upgrade to Plied Pro', 'plied'); ?>
					</a>
				</p>
			</div>

			<div class="plied-adm-wid-49 theme-para theme-opt plied-adm-mobwid-100">
				<h4><?php esc_html_e('Theme Options','plied'); ?></h4>
				<p class="">
					<?php esc_html_e('Plied Theme supports Theme Customizer. Click "Go To Customizer" to open the Customizer now.',  'plied'); ?>
				</p>
				<p>
					<a href="<?php echo esc_url(admin_url('customize.php') ); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Go To Customizer', 'plied'); ?>
					</a>
				</p>
			</div>

			<div class="plied-adm-wid-49 theme-para theme-review plied-adm-mobwid-100">
				<h4><?php esc_html_e('Leave us a review','plied'); ?></h4>
				<p><?php esc_html_e('We would love to hear your feedback.', 'plied'); ?></p>
				<p>
					<a href="<?php echo esc_url('https://wordpress.org/support/theme/plied/reviews/#new-post'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Submit a review', 'plied'); ?>
					</a>
				</p>
			</div>


			<div class="plied-adm-wid-49 theme-para theme-support plied-adm-mobwid-100">
				<h4><?php esc_html_e('Support','plied'); ?></h4>
				<p><?php esc_html_e('Reach out in the theme support forums on WordPress.org.', 'plied'); ?></p>
				<p>
					<a href="<?php echo esc_url('https://wordpress.org/support/theme/plied/'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Support Forum', 'plied'); ?>
					</a>
				</p>
			</div>


			<div class="theme-upgrade plied-adm-wid-100">
				<table class="plied-adm-wid-100">
					<thead class="theme-table-head">
						<tr>
							<th class="feature"><h3><?php esc_html_e('Features', 'plied'); ?></h3></th>
							<th class="plied-adm-wid-33"><h3><?php esc_html_e('Plied', 'plied'); ?></h3></th>
							<th class="plied-adm-wid-33"><h3><?php esc_html_e('Plied Pro', 'plied'); ?></h3></th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td class="feature-items-title">
								<h3><?php esc_html_e('Theme Price', 'plied'); ?></h3>
							</td>
							<td class="free-btn"><?php esc_html_e('Free', 'plied'); ?></td>
							<td>
								<a class="pro-link-btn" href="<?php echo esc_url('https://zidithemes.com/plied-pro/'); ?>" target="_blank">
									<?php esc_html_e('View Pricing', 'plied'); ?>
								</a>
							</td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Responsive Design', 'plied'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Portfolio Page Template', 'plied'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Testimonials Page Template', 'plied'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Team Page Template', 'plied'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Gallery Page Template', 'plied'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Pricing Page Template', 'plied'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('One Column Post Template', 'plied'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('3 News Grid Image Styles', 'plied'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Full Width Template', 'plied'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Footer Credits Options', 'plied'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Color Options', 'plied'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Gutenberg Compatible', 'plied'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Elementor Compatible', 'plied'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Major Browser Compatible', 'plied'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Woocommerce Compatible', 'plied'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class=""></td>
							<td class=""></td>
							<td class="go-pro">
								<span class="">
									<a class="link" href="<?php echo esc_url('https://zidithemes.com/plied-pro/'); ?>" target="_blank">
										<?php esc_html_e('View Pro', 'plied'); ?>
									</a>
								</span>
							</td>
						</tr>
					</tbody>
				</table>
			</div>

		</div>
	</div>
	<?php
}
?>
