<?php
/**
 * The template for displaying single posts
 *
 * This is the template that displays all single posts by default.
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0.0
 */

get_header(); ?>

  <div id="pf-main-content-container-row" class="row">
    <div id="pf-main-content-container-column" class="large-12 columns" role="main">

	  <div id="pf-main-content-container">

			<div class="off-canvas-wrap" data-offcanvas>
				<div class="inner-wrap">

          <?php pf_the_page_menu(); ?>  

					<section class="main-section">

						<?php
							$display_sidebars = get_theme_mod( 'pf_display_sidebars' );
							$left_sidebar = is_active_sidebar( 'left' );
							$right_sidebar = is_active_sidebar( 'primary' );
						?>

						<?php if ( $display_sidebars && $left_sidebar ) : ?>
							<div class="hide-for-medium-down large-3 columns">
								<?php dynamic_sidebar( 'left' ); ?>
							</div>
						<?php endif; ?>

						<?php if ( $display_sidebars && $left_sidebar && $right_sidebar ) : ?>
							<div class="large-6 columns">
						<?php elseif ( ( $display_sidebars && $left_sidebar && !$right_sidebar ) || ( $display_sidebars && !$left_sidebar && $right_sidebar ) ) : ?>
							<div class="large-9 columns">
						<?php else : ?>
							<div class="large-12 columns">
						<?php endif; ?>

 		        <?php while ( have_posts() ) : the_post(); ?>
       	      	<?php get_template_part( 'content', get_post_format() ); ?>
       	  	<?php endwhile; ?>

						</div>

						<?php if ( $display_sidebars && $right_sidebar ) : ?>
							<div class="hide-for-medium-down large-3 columns">
								<?php dynamic_sidebar( 'primary' ); ?>
							</div>
						<?php endif; ?>
     

       		</section> <!-- .main-section -->

       		<a class="exit-off-canvas"></a>

        </div><!-- .inner-wrap -->
      </div><!-- .off-canvas-wrap -->

	  </div><!-- #pf-main-content-container -->
    </div><!-- #pf-main-content-container-column -->
  </div><!-- #pf-main-content-container-row -->

<?php get_footer(); ?>
