<?php
/**
 * The template for displaying all static pages
 *
 * This is the template that displays all static pages by default.
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0.0
 */

get_header(); ?>

	<div id="pf-main-content-container-row" class="row">
		<div id="pf-main-content-container-column" class="large-12 columns" role="main">
		  <div id="pf-main-content-container">

			<div class="off-canvas-wrap" data-offcanvas>
				<div class="inner-wrap">

          <?php pf_the_page_menu(); ?>

					<section class="main-section" data-equalizer>


						<?php
							$display_sidebars = get_theme_mod( 'pf_display_sidebars' );
							$left_sidebar = is_active_sidebar( 'left' );
							$right_sidebar = is_active_sidebar( 'primary' );
						?>

						<?php if ( $display_sidebars && $left_sidebar ) : ?>
							<div class="pf-left-sidebar hide-for-medium-down large-3 columns" data-equalizer-watch>
								<?php dynamic_sidebar( 'left' ); ?>
							</div>
						<?php endif; ?>

						<?php if ( $display_sidebars && $left_sidebar && $right_sidebar ) : ?>
							<div id="pf-middle-content" class="large-6 columns" data-equalizer-watch>
						<?php elseif ( ( $display_sidebars && $left_sidebar && !$right_sidebar ) || ( $display_sidebars && !$left_sidebar && $right_sidebar ) ) : ?>
							<div id="pf-middle-content" class="large-9 columns" data-equalizer-watch>
						<?php else : ?>
							<div id="pf-middle-content" class="large-12 columns" data-equalizer-watch>
						<?php endif; ?>

						<?php while ( have_posts() ) : the_post(); ?>

							<?php
								$post_classes = get_post_class( 'pf-page' );
									if ( ! pf_show_author() )
										$post_classes = pf_remove_hentry_class( $post_classes, '');
									else
										$post_classes = implode( $post_classes );
							?>

							<article id="post-<?php the_ID(); ?>" class="<?php echo $post_classes; ?>">

								<?php if( pf_show_title() ) : ?>
									<header class="entry-header row">
										<div class="large-12 columns">
											<h2 class="entry-title"><?php the_title(); ?></h2>
											<div class="entry-meta pf-edit-post-link-container">
												<?php edit_post_link( __( 'Edit Page', 'planet-foundation' ) ); ?>
											</div>
											<hr />
										</div>
									</header><!-- .entry-header -->
								<?php endif; ?>

								<div class="entry-content row">

									<?php
										// utilizing a custom field for displaying additional images.
										global $pf_metabox_optional_images;
										$meta = $pf_metabox_optional_images->the_meta();

								    if ( $meta && $meta['images'] ) {

											echo '<div class="hide-for-small medium-3 large-4 columns">';
											?>

												<?php
													if ( $meta && $meta['images'] ) {
													global $wpdb;
													$optional_images = $meta['images'];

													foreach( $optional_images as $key => $optional_image ) {
														$optional_image_url = $optional_image['imgurl'];
														$query = "SELECT ID FROM {$wpdb->posts} WHERE guid='$optional_image_url'";
														$attachment_id = $wpdb->get_var($query);
														$attachment = get_post( $attachment_id );
														$optional_img_url = wp_make_link_relative( $optional_image_url );
														$post_img_alt = get_post_meta($attachment->ID, '_wp_attachment_image_alt', true);
														$post_img_title = $attachment->post_excerpt;
												?>
														<figure class="pf-figure">
															<img alt="<?php echo $post_img_alt; ?>" title="<?php echo $post_img_title; ?>" src="<?php echo $optional_image_url; ?>" />
															<?php if( $post_img_title ) : ?>
																<figcaption class="text-center show-for-large-up">
																	<?php echo $post_img_title; ?>
																</figcaption>
															<?php endif; ?>
														</figure>
												<?php
													}
													}
											echo '</div><!-- .hide-for-small, etc. -->';
										}
									?>
							    <?php if ( ( $meta && $meta['images'] ) || has_post_thumbnail() ) : ?>
										<div class="medium-9 large-8 columns">
									<?php else : ?>
										<div class="large-12 columns">
                  <?php endif; ?>
											<?php the_content(); ?>
											<?php pf_pagination(); ?>
										</div><!-- .medium-9, etc. -->

								</div><!-- .entry-content -->

								<?php if ( pf_show_author() ) : ?>
									<?php echo pf_get_the_author( '', 'bio_w_posts'); ?>
								<?php endif; ?>

							</article><!-- #post -->

							<div class="pf-comment-respond">
								<?php if ( comments_open() ) : ?>
									<?php comments_template(); ?>
								<?php endif; ?>
							</div>

						<?php endwhile; ?>

            </div>

						<?php if ( $display_sidebars && $right_sidebar ) : ?>
							<div class="pf-right-sidebar hide-for-medium-down large-3 columns" data-equalizer-watch>
								<?php dynamic_sidebar( 'primary' ); ?>
							</div>
						<?php endif; ?>

					</section> <!-- .main-section -->

					<a class="exit-off-canvas"></a>

				</div><!-- .inner-wrap -->
			</div><!-- .off-canvas-wrap -->

		  </div><!-- #pf-main-content-container -->
		</div><!-- #pf-main-content-container-column -->
	</div><!-- #pf-main-content-container-row -->

<?php get_footer(); ?>
