<?php
/**
 * Creates regions for placing widgets
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0
 */


/** 
 *
 * Adds regions for widget placement including a left and right sidebar, footer, and pre-header
 *
 * @return void
 */
function pf_register_sidebars() {


    register_sidebar(array(
    	'id' => 'pre-header',
    	'name' => __( 'Pre-header', 'planet-foundation' ),
    	'description' => __( 'Used to configure Pre-header.  If no widget is specified, logo, title, and taglines will be used', 'planet-foundation' ),
    	'before_widget' => '<div id="%1$s" class="widget %2$s">',
    	'after_widget' => '</div>',
    	'before_title' => '<h4 class="pf-widget-title">',
    	'after_title' => '</h4>'
    ));

    register_sidebar(array(
    	'id' => 'primary',
    	'name' => __( 'Right Sidebar', 'planet-foundation' ),
    	'description' => __( 'Used to configure right sidebars.  If no widget is specified, sidebar will not be displayed', 'planet-foundation' ),
    	'before_widget' => '<div id="%1$s" class="pf-primary pf-sidebar widget %2$s">',
    	'after_widget' => '</div>',
    	'before_title' => '<h4 class="pf-widget-title pf-sidebar-title">',
    	'after_title' => '</h4>'
    ));

    register_sidebar(array(
    	'id' => 'left',
    	'name' => __( 'Left Sidebar', 'planet-foundation' ),
    	'description' => __( 'Used to configure left sidebars.  If no widget is specified, sidebar will not be displayed', 'planet-foundation' ),
    	'before_widget' => '<div id="%1$s" class="pf-left pf-sidebar widget %2$s">',
    	'after_widget' => '</div>',
    	'before_title' => '<h4 class="pf-widget-title pf-sidebar-title">',
    	'after_title' => '</h4>'
    ));

    register_sidebar(array(
    	'id' => 'footer',
    	'name' => __( 'Footer', 'planet-foundation' ),
    	'description' => __( 'Configure your Footer. Specifying a widget here will override default', 'planet-foundation' ),
    	'before_widget' => '<article id="%1$s" class="widget %2$s">',
    	'after_widget' => '</article>',
    	'before_title' => '<h4 class="pf-widget-title">',
    	'after_title' => '</h4>'
    ));
}
add_action( 'widgets_init', 'pf_register_sidebars' );

?>