<?php
/**
 * Tells WordPress what this theme supports
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0.0
 */

/**
 * Registers supports for this theme
 *
 * @since Planet Foundation 1.0.0
 *
 * @link http://codex.wordpress.org/Theme_Features Theme Support and Features
 *
 */
function pf_theme_support() {
	// Add language supports.
	load_theme_textdomain('planet-foundation', get_template_directory() . '/lang');
	// Add post thumbnail supports. http://codex.wordpress.org/Post_Thumbnails
	add_theme_support('post-thumbnails');
	set_post_thumbnail_size( 300 );

	// Add post formarts supports. http://codex.wordpress.org/Post_Formats
	add_theme_support('post-formats', array('aside', 'video', 'gallery', 'link', 'image', 'quote', 'status'));

	// Add support for html5
	add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form' ) );


	// Add feed links.
	add_theme_support('automatic-feed-links');


	// Add menu supports. http://codex.wordpress.org/Function_Reference/register_nav_menus
	register_nav_menu( 'primary', __( 'Navigation Menu', 'planet-foundation' ) );


	// Add custom background support. http://codex.wordpress.org/Custom_Backgrounds
	add_theme_support( 'custom-background',
		array(
			'default-image' => '',  // background image default
			'default-color' => '#fff', // background color default (dont add the #)
			'wp-head-callback' => 'pf_custom_background_cb',
			'admin-head-callback' => '',
			'admin-preview-callback' => ''
		)
	);

	// Add custom header support. http://codex.wordpress.org/Custom_Headers
	// Header will be used as default when page and posts have not specified
	// elsewhere
	$header_args = array(
	'default-image'		  => '',
	'random-default'		 => false,
	'default-text-color'	 => '',
	'header-text'			=> false,
	'uploads'				=> true,
	'wp-head-callback'	   => 'pf_custom_background_cb',
	'admin-head-callback'	=> '',
	'admin-preview-callback' => '',
	);
	add_theme_support( 'custom-header', $header_args );

	// Add this theme's content width
	if ( ! isset( $content_width ) )
		$content_width = 1000;
}
add_action('after_setup_theme', 'pf_theme_support');


?>