<?php
/**
 * Functions to add theme stylesheets in header
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0.0
 *
 */

/**
 * Adds sass generated css to header.
 *
 * @since Planet Foundation 1.0.0
 *
 */
function pf_styles() {

	// Register the main style


	wp_register_style( 'planet-foundation', get_template_directory_uri() . '/foundation/stylesheets/planet-foundation.css', array(), '', 'all' );
	wp_enqueue_style( 'planet-foundation' );

  if ( is_child_theme() ) {
    // only load if there is a child theme involved
		wp_register_style( 'planet-foundation-child', get_stylesheet_directory_uri() . '/style.css' );
		wp_enqueue_style( 'planet-foundation-child' );
	}

}
add_action( 'wp_enqueue_scripts', 'pf_styles' );

/**
 * Adds theme styles for WordPress WYSIWYG editor
 *
 * @since Planet Foundation 1.0.0
 *
 */
function pf_add_editor_styles() {
	add_editor_style( get_template_directory_uri() . '/foundation/stylesheets/planet-foundation.css' );
}
add_action( 'init', 'pf_add_editor_styles' );

?>