<?php 
/**
 * For creating main navigation menu
 *
 * Thanks to Reverie Theme
 *
 * @link http://themefortress.com/reverie/ Reverie Theme
 * @copyright Theme Fortress 2013, themefortress.com/reverie/
 * @license Distributed under MIT license, http://choosealicense.com/licenses/mi *
 * @package ncp\wp\themes\planet_foundation
 *
 * @since Planet Foundation 1.0.0
 *
 */


/**
 * Helps create the main navigation menu styled for Zurb's Foundation Top Bar module
 *
 * @since Planet Foundation 1.0.0
 *
 * @link http://foundation.zurb.com/docs/components/topbar.html Zurb's Foundation Top Bar
 * @link http://www.kriesi.at/archives/improve-your-wordpress-navigation-menu-output Thanks to Kriesi.at
 * @link https://github.com/swalkinshaw Thanks to Swalkinshaw
 * @link http://themes.required.ch Thanks to required+ themes
 * 
 */
class pf_walker extends Walker_Nav_Menu {

	/**
	 * Specify the item type to allow different walkers
	 * @var array unknown
	 */
	var $nav_bar = '';

  var $count = 0;

  /**
   * The constructor
   *
   * @param $nav_args
   */
	function __construct( $nav_args = '' ) {

		$defaults = array(
			'item_type' => 'li',
			'in_top_bar' => false,
			'menu_type' => 'main-menu' //enable menu differenciation, used in preg_replace classes[] below
		);
		$this->nav_bar = apply_filters( 'req_nav_args', wp_parse_args( $nav_args, $defaults ) );
	}

  /**
    * display_element()
    *
    * @param $element
    * @param $children_elements
    * @param $max_depth
    * @param $depth
    * @param $args
    * @param $output
    */
	function display_element( $element, &$children_elements, $max_depth, $depth=0, $args, &$output ) {

        $id_field = $this->db_fields['id'];
        if ( is_object( $args[0] ) ) {
            $args[0]->has_children = ! empty( $children_elements[$element->$id_field] );
        }
        return parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
    }

  /**
   * start_el()
   *
   * @param $output
   * @param $item
   * @param $depth
   * @param $args
   * @param $id
   */
	function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {

		global $wp_query;
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

    $this->count++;

		$class_names = $value = '';

		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$classes[] = 'menu-item-' . $item->ID;

    // Additionnal Class cleanup, as found in Roots_Nav_Walker - Roots Theme lib/nav.php
    // see http://roots.io/ and https://github.com/roots/roots
    $slug = sanitize_title($item->title);
    $classes = preg_replace('/(current(-menu-|[-_]page[-_])(item|parent|ancestor))/', '', $classes);
    $classes = preg_replace('/^((menu|page)[-_\w+]+)+/', '', $classes);

    $menu_type = $this->nav_bar['menu_type'];
    $classes[] = 'menu-item menu-item-' . $menu_type . ' menu-item-' . $slug;
    
    $classes = array_unique($classes);

		// Check for flyout
		$flyout_toggle = '';
		if ( $args->has_children && $this->nav_bar['item_type'] == 'li' ) {

			if ( $depth == 0 && $this->nav_bar['in_top_bar'] == false ) {

				$classes[] = 'has-flyout';
				$flyout_toggle = '<a href="#" class="flyout-toggle"><span></span></a>';

			} else if ( $this->nav_bar['in_top_bar'] == true ) {

				$classes[] = 'has-dropdown';
				$flyout_toggle = '';
			}

		}

		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
		$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

		if ( $depth > 0 ) {
			$output .= $indent . '<li id="menu-item-'. $item->ID . '"' . $value . $class_names .'>';
		} else {
			$output .= $indent . ( ( $this->count > 1 && $this->nav_bar['in_top_bar'] == true ) ? '<li class="divider"></li>' : '' ) . '<' . $this->nav_bar['item_type'] . ' id="menu-item-'. $item->ID . '"' . $value . $class_names .'>';
		}

		$attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
		$attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
		$attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
		$attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';

		$item_output  = $args->before;
		$item_output .= '<a '. $attributes .'>';
		$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
		$item_output .= '</a>';
		$item_output .= $flyout_toggle; // Add possible flyout toggle
		$item_output .= $args->after;

		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	}

  /**
   * end_el()
   *
   * @param $output
   * @param $item
   * @param $depth
   * @param $args
   */
	function end_el( &$output, $item, $depth = 0, $args = array() ) {

		if ( $depth > 0 ) {
			$output .= "</li>\n";
		} else {
			$output .= "</" . $this->nav_bar['item_type'] . ">\n";
		}
	}

  /**
   * start_lvl()
   *
   * @param $output
   * @param $depth
   * @param $args
   */
	function start_lvl( &$output, $depth = 0, $args = array() ) {

		if ( $depth == 0 && $this->nav_bar['item_type'] == 'li' ) {
			$indent = str_repeat("\t", 1);
    		$output .= $this->nav_bar['in_top_bar'] == true ? "\n$indent<ul class=\"dropdown\">\n" : "\n$indent<ul class=\"flyout\">\n";
    	} else {
			$indent = str_repeat("\t", $depth);
    		$output .= $this->nav_bar['in_top_bar'] == true ? "\n$indent<ul class=\"dropdown\">\n" : "\n$indent<ul class=\"level-$depth\">\n";
		}
  	}
}