<?php

require_once( 'wpalchemy/MetaBox.php' );
require_once( 'wpalchemy/MediaAccess.php' );

$wpalchemy_ma_header_image = new WPAlchemy_MediaAccess();
$wpalchemy_ma_optional_images = new WPAlchemy_MediaAccess();


$pf_metabox_header_image = new WPAlchemy_MetaBox(array
(
    'id' => '_pf_meta_header_image',
    'title' => 'Planet Foundation Header Image',
    'template' => get_template_directory() . '/lib/metabox-header-image.php',
	'types' => array( 'post', 'page', 'guides', 'trip' ),
));


$pf_metabox_optional_images = new WPAlchemy_MetaBox(array
(
    'id' => '_pf_meta_other_images',
    'title' => 'Planet Foundation Optional Images',
    'template' => get_template_directory() . '/lib/metabox-optional-images.php',
));


/**
 * Adds a box to the main column on the Post and Page edit screens.
 */
function pf_add_custom_box() {

    $screens = array( 'post', 'page', 'trip', 'guides' );

    foreach ( $screens as $screen ) {

        add_meta_box(
            'planet-foundation-post-section',
            __( 'Other Planet Foundation Settings', 'planet-foundation' ),
            'pf_inner_custom_box_cb',
            $screen
        );
    }
}
add_action( 'add_meta_boxes', 'pf_add_custom_box' );

/**
 * Prints the box content.
 * 
 * @param WP_Post $post The object for the current post/page.
 */
function pf_inner_custom_box_cb( $post ) {

  // Add an nonce field so we can check for it later.
  wp_nonce_field( 'pf_inner_custom_box', 'pf_inner_custom_box_nonce' );

  /*
   * Use get_post_meta() to retrieve an existing value
   * from the database and use the value for the form.
   */
  $value = get_post_meta( $post->ID, '_pf_show_author_key', true );

	$screen = get_current_screen();
  if ( $value == 'On' || ( empty( $value ) && ($screen->post_type == 'post' ) ) )	  echo '<input type="checkbox" id="pf_show_author_field" name="pf_show_author_field" value="On" checked="checked" />';
	else
	  echo '<input type="checkbox" id="pf_show_author_field" name="pf_show_author_field" value="On" />';

  echo '<label for="pf_show_author_field"> ';
       _e( "Show Author", 'planet-foundation' );
  echo '</label> ';

  echo '<br /> ';

  $value = get_post_meta( $post->ID, '_pf_show_title_key', true );

  if ( !$value || $value == 'On' )
	  echo '<input type="checkbox" id="pf_show_title_field" name="pf_show_title_field" value="On" checked="checked" />';
	else
	  echo '<input type="checkbox" id="pf_show_title_field" name="pf_show_title_field" value="On" />';

  echo '<label for="pf_show_title_field"> ';
       _e( "Show Title", 'planet-foundation' );
  echo '</label> ';

  echo '<br /> ';

  $value = get_post_meta( $post->ID, '_pf_show_tags_key', true );

  if ( $value == 'On' || ( empty( $value ) && ($screen->post_type == 'post' ) ) )
	  echo '<input type="checkbox" id="pf_show_tags_field" name="pf_show_tags_field" value="On" checked="checked" />';
	else 
	  echo '<input type="checkbox" id="pf_show_tags_field" name="pf_show_tags_field" value="On" />';

  echo '<label for="pf_show_tags_field"> ';
       _e( "Show Tags", 'planet-foundation' );
  echo '</label> ';

}

/**
 * When the post is saved, saves our custom data.
 *
 * @param int $post_id The ID of the post being saved.
 */
function pf_save_postdata( $post_id ) {

  /*
   * We need to verify this came from the our screen and with proper authorization,
   * because save_post can be triggered at other times.
   */

  // Check if our nonce is set.
  if ( ! isset( $_POST['pf_inner_custom_box_nonce'] ) )
    return $post_id;

  $nonce = $_POST['pf_inner_custom_box_nonce'];

  // Verify that the nonce is valid.
  if ( ! wp_verify_nonce( $nonce, 'pf_inner_custom_box' ) )
      return $post_id;

  // If this is an autosave, our form has not been submitted, so we don't want to do anything.
  if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) 
      return $post_id;

  // Check the user's permissions.
  if ( 'page' == $_POST['post_type'] ) {

    if ( ! current_user_can( 'edit_page', $post_id ) )
        return $post_id;
  
  } else {

    if ( ! current_user_can( 'edit_post', $post_id ) )
        return $post_id;
  }

  /* OK, its safe for us to save the data now. */

  // Sanitize user input.
  $data =  $_POST['pf_show_author_field'];
  if ( $data != 'On' )
		$data = 'Off';

  // Update the meta field in the database.
  update_post_meta( $post_id, '_pf_show_author_key', $data );

  // Sanitize user input.
  $data =  $_POST['pf_show_title_field'];
  if ( $data != 'On' )
		$data = 'Off';

  // Update the meta field in the database.
  update_post_meta( $post_id, '_pf_show_title_key', $data );

  // Sanitize user input.
  $data =  $_POST['pf_show_tags_field'];
  if ( $data != 'On' )
		$data = 'Off';

  // Update the meta field in the database.
  update_post_meta( $post_id, '_pf_show_tags_key', $data );
}
add_action( 'save_post', 'pf_save_postdata' );


?>
