<?php
/**
 * Functions to add messages to the wordpress dashboard
 *
 * @package ncp\wp\themes\planet_foundation
 *
 * @since Planet Foundation 1.3.7
 *
 */

/**
 * Add widget panel for planet foundation theme to dashboard
 *
 * @access      public
 * @since       1.3.7
 * @return      void
*/
function pf_add_theme_dashboard_widget( $post, $callback_args ) {
	$theme_obj = wp_get_theme('planet-foundation');
	$theme_ver = $theme_obj->get( 'Version' );
	echo "<h2>Planet Foundation Theme, Version $theme_ver</h2>";
	echo '<p>Thank you for using the Planet Foundation theme. Here are some links you may find useful:</p>';
	echo '<ul>';
	echo '<li><a title="Learn about theme features and configuration" href="http://www.norcalplanet.com/planet-foundation-documentation">Theme Documentation</a></li>';
	echo '<li><a title="Visit the theme forum" href="https://wordpress.org/support/theme/planet-foundation">Theme Support</a></li>';
	echo '</ul>';
	echo '<p>If you like this theme, consider adding a <a title="Visit the theme forum" href="https://wordpress.org/support/view/theme-reviews/planet-foundation">Review</a></p>';
	echo '<p>This theme is free, but it takes a lot of work to maintain it. If you like this theme and use it, please consider helping a guy out by contributing towards its support. Thank you!</p>';
	echo '<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_top">';
	echo '<input type="hidden" name="cmd" value="_s-xclick">';
	echo '<input type="hidden" name="hosted_button_id" value="AWWELLYDFBEV8">';
	echo '<input type="image" src="https://www.paypalobjects.com/en_US/i/btn/btn_donateCC_LG.gif" border="0" name="submit" alt="PayPal - The safer, easier way to pay online!">';
	echo '<img alt="" border="0" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif" width="1" height="1">';
	echo '</form>';
}
function pf_add_dashboard_widgets() {
	if ( current_user_can( 'edit_theme_options') ) {
		wp_add_dashboard_widget('pf-theme-dashboard-widget', 'Planet Foundation Theme', 'pf_add_theme_dashboard_widget');

		// Attempt to get our widget to the top of the list
		global $wp_meta_boxes;
	 	$normal_dashboard = $wp_meta_boxes['dashboard']['normal']['core'];
		$widget_backup = array( 'dashboard_widget' => $normal_dashboard['pf-theme-dashboard-widget'] );
	 	unset( $normal_dashboard['pf-theme-dashboard-widget'] );
	  	$sorted_dashboard = array_merge( $widget_backup, $normal_dashboard );
	  	$wp_meta_boxes['dashboard']['normal']['core'] = $sorted_dashboard;
	}
}
add_action('wp_dashboard_setup', 'pf_add_dashboard_widgets' );
