<?php
/**
 * Adds Zurb Foundation buttons to Wordpress WYSIWYG editor
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0.0
 *
 */

/**
 * Adds Style button to editor
 *
 * @since Planet Foundation 1.0.0
 *
 * @param Array $buttons Array of editor buttons
 *
 * @return Array Modified array
 */
function pf_foundation_buttons( $buttons ) {
	array_unshift( $buttons, 'styleselect' );
	return $buttons;
}
add_filter( 'mce_buttons_2', 'pf_foundation_buttons' );


/**
 * Adds some Zurb's Foundation styles to TinyMCE menu
 * 
 * pf_add_more_styles_to_mce filters are applied at the end of this function to allow
 * child themes to add more styles to the menu.
 *
 * @since Planet Foundation 1.0.0
 *
 * @link http://code.tutsplus.com/tutorials/adding-custom-styles-in-wordpress-tinymce-editor--wp-24980 Custom Styles to TinyMCE
 *
 * @param array $settings
 * @return array Modified settings
 *
 */
function pf_mce_before_init( $settings ) {
 
	$style_formats = array(
		array(
			'title' => 'Panel',
			'block' => 'div',
			'classes' => 'panel'
		),
		array(
			'title' => 'Callout',
			'block' => 'div',
			'classes' => 'panel callout'
		),
		array(
			'title' => 'Button',
			'inline' => 'a',
			'classes' => 'button'
		),
		array(
			'title' => 'Tiny Button',
			'inline' => 'a',
			'classes' => 'tiny button'
		),
		array(
			'title' => 'Small Button',
			'inline' => 'a',
			'classes' => 'small button'
		),
		array(
			'title' => 'Large Button',
			'inline' => 'a',
			'classes' => 'large button'
		),
		array(
			'title' => 'h1.subheader',
			'block' => 'h1',
			'classes' => 'subheader'
		),
		array(
			'title' => 'h2.subheader',
			'block' => 'h2',
			'classes' => 'subheader'
		),
		array(
			'title' => 'h3.subheader',
			'block' => 'h3',
			'classes' => 'subheader'
		),
		array(
			'title' => 'h4.subheader',
			'block' => 'h4',
			'classes' => 'subheader'
		),
		array(
			'title' => 'h5.subheader',
			'block' => 'h5',
			'classes' => 'subheader'
		),
		array(
			'title' => 'Hide For Small',
			'block' => 'div',
			'classes' => 'hide-for-small'
		),
		array(
			'title' => 'Flex Video',
			'block' => 'div',
			'classes' => 'flex-video'
		),
	);
 


	/**
	 * Apply pf_add_more_styles_to_mce filters
	 * 
	 * Allows child themes to add more 
	 *
	 * @since Planet Foundation 1.0.0
   *
   * @param array $style_formats Array of styles
   *
   * @return array Mofified $style_formats
   *
	 */
	$style_formats = apply_filters('pf_add_more_styles_to_mce', $style_formats );

	$settings['style_formats'] = json_encode( $style_formats );

	return $settings;
}
add_filter('tiny_mce_before_init', 'pf_mce_before_init');

?>