<?php
/**
 * Zurb Foundation Lightbox Integration
 *
 * @package ncp\wp\themes\planet_foundation 
 * @since Planet Foundation 1.0.0
 */

/**
 * Replaces any wordpress gallery shortcodes with Zurb Foundation's Lightbox.
 *
 * Columns and links gallary options are not supported
 *
 * @since Planet Foundation 1.0.0
 *
 * @link http://foundation.zurb.com/docs/components/clearing.html Zurb's Foundation Clearing Lightbox
 *
 * @param string $value HTML to filter, not used
 * @param string $attr string of shortcode attributes
 * 
 * @return string HTML for gallery lightbox 
 */
function pf_post_gallery ( $value, $attr ) {

	if ( empty( $attr['ids'] ) ) {
		// if there are no ids, we ain't going to mess with this
		return '';
	}

	$id_str = $attr['ids'];
	$ids = explode( ',', $id_str);

	/* Sanitize attributes */
	if ( isset( $attr['orderby'] ) ) {
		if ( $attr['orderby'] == 'rand' ) {
			shuffle( $ids );
		}
	}
	/* End Sanitize */


	$html = '<p><ul class="clearing-thumbs" data-clearing>';
	// Loop through images, integrate into Foundation's Clearing Lightbox
	$i=0;
	foreach( $ids as $id ) {
		$img_thumb = wp_get_attachment_image_src( $id, 'thumbnail' );
		$img_full = wp_get_attachment_image_src( $id, 'full' );
		$attachment = get_post( $id );
		$caption = $attachment->post_excerpt;
		if ( ! empty( $caption ) )
			$caption = "data-caption=\"$caption\"";

		$html = $html . '<li><a href="' . esc_url( $img_full[0] ) . '"><img ' . $caption. ' src="' . esc_url( $img_thumb[0] ) . '" class="pf-full-gallery-image pf-full-gallery-image-' . $i . '" alt="Gallery image" /></a></li>';
		$i++;
	}

	$html = $html . '</ul></p><!-- .clearing-thumbs -->';

	return $html;
}
add_filter ( "post_gallery", "pf_post_gallery", 100, 2 );


?>
