jQuery( document ).ready( function() {
	var kb = jQuery( "ul[data-ken-burns]" );
	if ( kb ) {
	  var kenBurnsEffect = new pfKenBurns();	
		kenBurnsEffect.animateSlide();
	}
});


// Data options
pfKenBurns.prototype.originX = new Array();
pfKenBurns.prototype.originY = new Array();
pfKenBurns.prototype.destX = new Array();
pfKenBurns.prototype.destY = new Array();
pfKenBurns.prototype.scrollDur = new Array();
pfKenBurns.prototype.fadeDur = new Array();
pfKenBurns.prototype.displayDur = new Array();

// Slide info
pfKenBurns.prototype.$topSlide;
pfKenBurns.prototype.$nextSlide;
pfKenBurns.prototype.$topCaption;
pfKenBurns.prototype.$nextCaption;
pfKenBurns.prototype.$slides;
pfKenBurns.prototype.$captions;
pfKenBurns.prototype.slideNum = 0;
pfKenBurns.prototype.numOfSlides;

function pfKenBurns() {

	// get all li elements for the ken burns ul
	$liElements = jQuery( "ul[data-ken-burns] > li" );

	// store the slides and caption
	this.$slides = jQuery( "ul[data-ken-burns] > li img" );
	this.$captions = jQuery( "ul[data-ken-burns] > li > p.ken-burns-caption" );

	// init number of slides and first slide num.  First slide is the last in the list
	this.slideNum = this.$slides.length-1;
  this.numOfSlides = this.$slides.length;

  // iterate through them and parse the data-options
	var optionsStr = "";
	for ( var i = 0; i < $liElements.length; i++ ) {
		optionsStr = jQuery( $liElements[i] ).attr( "data-options" );

	  var origin = optionsStr.match( /origin: *(-?[0-9]+),(-?[0-9]+);/ );

	  this.originX[i] = Number(origin[1]);
	  this.originY[i] = Number(origin[2]);

	  var dest = optionsStr.match( /destination: *(-?[0-9]+),(-?[0-9]+);/ );
	  this.destX[i] = Number(dest[1]);
	  this.destY[i] = Number(dest[2]);

	  var x = optionsStr.match( /scrolling_duration: *([0-9]+);/ );
	  this.scrollDur[i] = Number(x[1]);

	  x = optionsStr.match( /fading_duration: *([0-9]+);/ );
	  this.fadeDur[i] = Number(x[1]);

	  x = optionsStr.match( /display_duration: *([0-9]+);/ );
	  this.displayDur[i] = Number(x[1]);

		// put the slides at their specified origin
		jQuery(this.$slides[i]).css("left",this.originX[i]);
		jQuery(this.$slides[i]).css("top",this.originY[i]);

	}

	// Add class to ul for styling
	var $kenBurnsElem = jQuery( "ul[data-ken-burns]" );
  $kenBurnsElem.addClass( "pf-ken-burns-slides" );

}

pfKenBurns.prototype.animateSlide = function() {

	var i = this.slideNum;
	var kb = this;  // a reference inside functions

  jQuery( this.$slides[i] ).animate(
    { top: this.destY[i], left: this.destX[i] }, this.scrollDur[i],
		function () {
			// Fade out slide after display duration
			if ( i == 0 ) {
				// We are at the bottom slide, fade in top slide
				kb.fadeIn();
			}
			else {
				// Slides are stacked, fade out to lower slide
				kb.fadeOut();
			}
		}
	);

}

pfKenBurns.prototype.fadeOut = function() {
			var i = this.slideNum;
			var kb = this;  // a reference for inside functions

			if (i == 0)
				throw "fadeOut: Don't call on bottom slide.  Use fadeIn";

			// make sure the slide and caption underneath is showing.
			jQuery( this.$slides[i-1] ).show();
			jQuery( this.$captions[i-1] ).show();

			// reposition next slide back to its origin
		  jQuery( kb.$slides[i-1] ).css("left", kb.originX[i-1] );
		  jQuery( kb.$slides[i-1] ).css("top", kb.originY[i-1] );

			// fade to slide underneath
			jQuery( this.$slides[i] ).delay( this.displayDur[i] ).fadeOut(
				{ duration: this.fadeDur[i],
					start:	function() {
							// Hide caption after display duration
							jQuery( kb.$captions[i] ).hide();
						},
					complete: function() {
							kb.slideNum--;
							kb.animateSlide();
						}
				}
			);
}

pfKenBurns.prototype.fadeIn = function() {

	if (this.slideNum != 0)
		throw "fadeIn: Only use fadeIn on bottom slide, else use fadeOut";

	this.slideNum = this.numOfSlides-1;
	var i = this.slideNum;
	var kb = this;  // for use in anonymous functions

	// Re-position top slide to its origin
  jQuery( this.$slides[i] ).css("left", this.originX[i] );
  jQuery( this.$slides[i] ).css("top", this.originY[i] );

	jQuery( this.$slides[i] ).delay( this.displayDur[0] ).fadeIn(
				{ duration: this.fadeDur[i],
					start:	function() {
							// Hide bottom caption after display duration
							jQuery( kb.$captions[0] ).hide();
							// Fade in top caption
							jQuery( kb.$captions[i] ).fadeIn( kb.fadeDur[i] );
						},
					complete: function() {
							// reposition next slide
						  jQuery( kb.$slides[i-1] ).css("left", kb.originX[i-1] );
						  jQuery( kb.$slides[i-1] ).css("top", kb.originY[i-1] );
							
							kb.animateSlide();
						}
				}
	);
}
