<?php
/**
 * Configuration of theme fonts
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0.0
 *
 */


/**
 * Checks theme customization and registers google fonts
 *
 * @since Planet Foundation 1.0.0
 *
 * @see http://codex.wordpress.org/Function_Reference/get_theme_mod get_theme_mod()
 * @see http://codex.wordpress.org/Function_Reference/wp_register_style wp_regsiter_style()
 * @see http://codex.wordpress.org/Function_Reference/wp_enqueue_style wp_enqueue_style()
 *
 */
function pf_load_fonts() {
	if ( $p_font = get_theme_mod( 'pf_google_font_address' ) ) {
		wp_register_style( 'googleFonts', esc_url( $p_font ) );
		wp_enqueue_style( 'googleFonts' );
	}
}
add_action('wp_print_styles', 'pf_load_fonts');

/**
 * Checks theme customization and adds css styling to header for fonts.
 *
 * Prints the html directly to UA.  Hook pf_add_more_custom_fonts called for
 * child themes to add more styling.  Called before </style> is printed.
 *
 * @see http://codex.wordpress.org/Function_Reference/get_theme_mod get_theme_mod()
 *
 */
function pf_add_customized_fonts () {
	?>
	<style type="text/css" media="screen">
  <?php

	if ( $style = get_theme_mod( 'pf_site_title_style' ) ) {
	?>
		h1.site-title {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_site_tagline_style' ) ) {
	?>
		h2.site-description {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_site_sub_tagline_style' ) ) {
	?>
		p.pf-sub-tagline {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_post_title_style' ) ) {
	?>
		h2.entry-title, h2.entry-title a {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_sidebar_title_style' ) ) {
	?>
		h4.pf-sidebar-title {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_footer_title_style' ) ) {
	?>
		h5.pf-footer-title {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}


	if ( $style = get_theme_mod( 'pf_main_p_style' ) ) {
	?>
		p, ul li {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_sidebar_p_style' ) ) {
	?>
		div.pf-sidebar p, .widget p {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_footer_p_style' ) ) {
	?>
		#pf-footer p {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_footer_p_style' ) ) {
	?>
		.pf-footer p {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $p_font_size = get_theme_mod( 'pf_paragraph_font_size' ) ) {
	?>
		p {
			<?php echo esc_attr( $p_font_size ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_navigation_a_style' ) ) {
	?>
		.top-bar-section ul li > a {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_navigation_a_hover_style' ) ) {
	?>
		.top-bar-section ul li > a:hover {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_main_a_style' ) ) {
	?>
		a {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_main_a_hover_style' ) ) {
	?>
		a:hover {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_sidebar_a_style' ) ) {
	?>
		.pf-sidebar a, .widget a {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_sidebar_a_hover_style' ) ) {
	?>
		.pf-sidebar a:hover {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_footer_a_style' ) ) {
	?>
		.pf-footer a:hover {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}

	if ( $style = get_theme_mod( 'pf_footer_a_hover_style' ) ) {
	?>
		.pf-footer a:hover {
			<?php echo esc_attr( $style ); ?>
		}
	<?php
	}


	/**
	 * Action hook pf_add_more_custom_fonts.
	 * 
	 * Allows child themes to add more font styling here.  Styling added before
	 * the </style> tag is printed.
	 *
	 * @since Planet Foundation 1.0.0
	 */
	do_action( 'pf_add_more_custom_fonts' );    
	?>  

	</style>
	<?php
}
add_action( 'wp_head', 'pf_add_customized_fonts' );

?>
