<?php
/**
 * Theme Customization
 *
 * Sets up what you see under Appearance->Customize
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0
 *
 */

/** A big honk'n function to add new menu items to Appearance->Customize
 *
 * Child themes can add more customization options using the pf_extend_customizer hook, which
 * is called at the end of this function
 *
 * @link https://codex.wordpress.org/Theme_Customization_API Theme Customization API
 *
 * @param WP_Customize_Manager $wp_customize Instance of WP_Customize_Manager
 *
 */
function pf_theme_customizer( $wp_customize ) {

	/* Changed ordering of default section */
	$wp_customize->get_section('title_tagline')->priority = 10;
	$wp_customize->get_section('nav')->priority = 20;
	$wp_customize->get_section('background_image')->priority = 30;
	$wp_customize->get_section('colors')->priority = 40;
	$wp_customize->get_section('header_image')->priority = 50;
	$wp_customize->get_section('static_front_page')->priority = 60;

	/* Add Logo Customizer */
	$wp_customize->add_section( 'pf_logo_section' , array(
		'title'       => __( 'Logo', 'planet-foundation' ),
		'priority'    => 11,
		'description' => 'Upload a logo. Used in pre-header along with title and taglines if no widget is used',
	) );

	$wp_customize->add_setting( 'pf_logo', array( 'sanitize_callback' => 'pf_sanitize_url_cb' ) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'pf_logo', array(
		'label'    => __( 'Logo', 'planet-foundation' ),
		'section'  => 'pf_logo_section',
		'settings' => 'pf_logo',
	) ) );
	/* End Add Logo Customizer */

	/* Font Customizer */
	$wp_customize->add_section( 'pf_font_section' , array(
		'title'       => __( 'Fonts Styles', 'planet-foundation' ),
		'priority'		=> 41,
		'description' => 'Font styles for paragraphs, links and headers.  Specify in CSS syntax (e.g. color:red; font-size:1rem; text-decoration:underline;',
	) );

	$wp_customize->add_setting( 'pf_google_font_address', array( 'sanitize_callback' => 'pf_sanitize_url_cb' ) );

	$wp_customize->add_setting( 'pf_site_title_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_site_tagline_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_site_sub_tagline_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );

	$wp_customize->add_setting( 'pf_post_title_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_sidebar_title_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_footer_title_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );

	$wp_customize->add_setting( 'pf_main_p_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_sidebar_p_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_footer_p_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );

	$wp_customize->add_setting( 'pf_navigation_a_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_navigation_a_hover_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_main_a_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_main_a_hover_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_sidebar_a_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_sidebar_a_hover_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_footer_a_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_footer_a_hover_style', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );


	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_google_font_address',
			array(
				'label'          => __( 'Google Font Address', 'planet-foundation' ),
				'section'        => 'pf_font_section',
				'settings'       => 'pf_google_font_address',
				'type'           => 'text',
				'priority'       => 1
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_site_title_style',
			array(
				'label'             => __( 'Site Title Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_site_title_style',
				'type'              => 'text',
				'priority'          => 2
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_site_tagline_style',
			array(
				'label'             => __( 'Site Tagline Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_site_tagline_style',
				'type'              => 'text',
				'priority'          => 3
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_site_sub_tagline_style',
			array(
				'label'             => __( 'Site Sub-Tagline Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_site_sub_tagline_style',
				'type'              => 'text',
				'priority'          => 4
			)
		)
	);



	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_post_title_style',
			array(
				'label'             => __( 'Post Title Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_post_title_style',
				'type'              => 'text',
				'priority'          => 5
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_sidebar_title_style',
			array(
				'label'             => __( 'Sidebar Title Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_sidebar_title_style',
				'type'              => 'text',
				'priority'          => 6
			)
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_footer_title_style',
			array(
				'label'             => __( 'Footer Title Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_footer_title_style',
				'type'              => 'text',
				'priority'          => 7
			)
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_main_p_style',
			array(
				'label'             => __( 'Main Paragraph Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_main_p_style',
				'type'              => 'text',
				'priority'          => 8
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_sidebar_p_style',
			array(
				'label'             => __( 'Sidebar Paragraph Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_sidebar_p_style',
				'type'              => 'text',
				'priority'          => 9
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_footer_p_style',
			array(
				'label'             => __( 'Footer Paragraph Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_footer_p_style',
				'type'              => 'text',
				'priority'          => 10
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_navigation_a_style',
			array(
				'label'             => __( 'Navigation Menu Link Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_navigation_a_style',
				'type'              => 'text',
				'priority'          => 10
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_navigation_a_hover_style',
			array(
				'label'             => __( 'Navigation Menu Link on Hover Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_navigation_a_hover_style',
				'type'              => 'text',
				'priority'          => 10
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_main_a_style',
			array(
				'label'             => __( 'Main Link Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_main_a_style',
				'type'              => 'text',
				'priority'          => 11
			)
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_main_a_hover_style',
			array(
				'label'             => __( 'Main Link on Hover Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_main_a_hover_style',
				'type'              => 'text',
				'priority'          => 12
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_sidebar_a_style',
			array(
				'label'             => __( 'Sidebar Link Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_sidebar_a_style',
				'type'              => 'text',
				'priority'          => 13
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_sidebar_a_hover_style',
			array(
				'label'             => __( 'Sidebar Link on Hover Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_sidebar_a_hover_style',
				'type'              => 'text',
				'priority'          => 14
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_footer_a_style',
			array(
				'label'             => __( 'Footer Link Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_footer_a_style',
				'type'              => 'text',
				'priority'          => 15
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_footer_a_hover_style',
			array(
				'label'             => __( 'Footer Link on Hover Style', 'planet-foundation' ),
				'section'           => 'pf_font_section',
				'settings'          => 'pf_footer_a_hover_style',
				'type'              => 'text',
				'priority'          => 16
			)
		)	
	);




	/* End Font Customizer */

	/* Background Color Customizer */
	$wp_customize->add_setting( 'pf_pre_header_bg_color', array( 'sanitize_callback' => 'sanitize_hex_color' ) );
	$wp_customize->add_setting( 'pf_navigation_bg_color', array( 'sanitize_callback' => 'sanitize_hex_color' ) );
	$wp_customize->add_setting( 'pf_page_menu_bg_color', array( 'sanitize_callback' => 'sanitize_hex_color' ) );
	$wp_customize->add_setting( 'pf_right_sidebar_bg_color', array( 'sanitize_callback' => 'sanitize_hex_color' ) );
	$wp_customize->add_setting( 'pf_left_sidebar_bg_color', array( 'sanitize_callback' => 'sanitize_hex_color' ) );
	$wp_customize->add_setting( 'pf_main_content_bg_color', array( 'sanitize_callback' => 'sanitize_hex_color' ) );
	$wp_customize->add_setting( 'pf_footer_bg_color', array( 'sanitize_callback' => 'sanitize_hex_color' ) );

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'pf_pre_header_bg_color',
			array(
				'label' => 'Pre-header Background Color',
				'section' => 'colors',
				'settings' => 'pf_pre_header_bg_color',
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'pf_main_content_bg_color',
			array(
				'label' => 'Main Content Background Color',
				'section' => 'colors',
				'settings' => 'pf_main_content_bg_color',
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'pf_right_sidebar_bg_color',
			array(
				'label' => __( 'Right Sidebar Background Color','planet-foundation' ),
				'section' => 'colors',
				'settings' => 'pf_right_sidebar_bg_color',
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'pf_left_sidebar_bg_color',
			array(
				'label' => __( 'Left Sidebar Background Color','planet-foundation' ),
				'section' => 'colors',
				'settings' => 'pf_left_sidebar_bg_color',
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'pf_footer_bg_color',
			array(
				'label' => 'Footer Background Color',
				'section' => 'colors',
				'settings' => 'pf_footer_bg_color',
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'pf_navigation_bg_color',
			array(
				'label' => 'Site Menu Background Color',
				'section' => 'colors',
				'settings' => 'pf_navigation_bg_color',
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'pf_page_menu_bg_color',
			array(
				'label' => 'Page Menu Background Color',
				'section' => 'colors',
				'settings' => 'pf_page_menu_bg_color',
			)
		)
	);
	/* End Background Color Customizer */

	/* Title and Tagline Customizer */
	$wp_customize->add_setting( 'pf_sub_tagline',
		array(
			'sanitize_callback' => 'pf_sanitize_text_cb'
		)
	);
	$wp_customize->add_setting( 'pf_pre_header_on_home_page',
		array (	'default' => 1,
				'sanitize_callback' => 'pf_sanitize_checkbox_cb'
			 )
	);
	$wp_customize->add_setting( 'pf_pre_header_first',
		array (	'default' => 0,
				'sanitize_callback' => 'pf_sanitize_checkbox_cb'
			 )
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_sub_tagline',
			array(
				'label'          => __( 'Sub-tagline', 'planet-foundation' ),
				'section'        => 'title_tagline',
				'settings'       => 'pf_sub_tagline',
				'type'           => 'text',
			)
		)
	);

	$wp_customize->add_control(
		'pf_pre_header_on_home_page',
		array(
			'type' => 'checkbox',
			'label'=> __( 'Title, taglines, logo on home page', 'planet-foundation' ),
			'section'  => 'title_tagline'
		 )
	 );
	$wp_customize->add_control(
		'pf_pre_header_first',
		array(
			'type' => 'checkbox',
			'label'=> __( 'Pre-Header Before Main Menu', 'planet-foundation' ),
			'section'  => 'title_tagline'
		 )
	 );

	/* End Title and Tagline Customizer */

	/* Header Customizer */
	$wp_customize->add_setting( 'pf_slide_1', array( 'sanitize_callback' => 'pf_sanitize_url_cb' ) );
	$wp_customize->add_setting( 'pf_slide_2', array( 'sanitize_callback' => 'pf_sanitize_url_cb' ) );
	$wp_customize->add_setting( 'pf_slide_3', array( 'sanitize_callback' => 'pf_sanitize_url_cb' ) );
	$wp_customize->add_setting( 'pf_slide_4', array( 'sanitize_callback' => 'pf_sanitize_url_cb' ) );
	$wp_customize->add_setting( 'pf_slide_5', array( 'sanitize_callback' => 'pf_sanitize_url_cb' ) );
	$wp_customize->add_setting( 'pf_slide_link_1', array( 'sanitize_callback' => 'pf_sanitize_url_cb' )	);
	$wp_customize->add_setting( 'pf_slide_caption_1', array( 'sanitize_callback' => 'pf_sanitize_text_cb' )	);

//	Can't specify default for add_setting here because of bug in theme checker code not liking semi-colons.  Leaving default specified here
//  for future reference
//  array( 'default' => 'origin:0,0; destination: 0,0; scrolling_duration: 5000; fading_duration: 3000; display_duration: 3000;', 'sanitize_callback' => 'pf_sanitize_text_cb' )
	$wp_customize->add_setting( 'pf_kb_options_1', array( 'sanitize_callback' => 'pf_sanitize_text_cb' )	);
	$wp_customize->add_setting( 'pf_slide_link_2',	array( 'sanitize_callback' => 'pf_sanitize_url_cb' ) );
	$wp_customize->add_setting( 'pf_slide_caption_2', array( 'sanitize_callback' => 'pf_sanitize_text_cb' )	);
	$wp_customize->add_setting( 'pf_kb_options_2', array( 'sanitize_callback' => 'pf_sanitize_text_cb' )	);

	$wp_customize->add_setting( 'pf_slide_link_3', array( 'sanitize_callback' => 'pf_sanitize_url_cb' )	);
	$wp_customize->add_setting( 'pf_slide_caption_3', array( 'sanitize_callback' => 'pf_sanitize_text_cb' )	);
	$wp_customize->add_setting( 'pf_kb_options_3', array( 'sanitize_callback' => 'pf_sanitize_text_cb' )	);

	$wp_customize->add_setting( 'pf_slide_link_4', array( 'sanitize_callback' => 'pf_sanitize_url_cb' )	);
	$wp_customize->add_setting( 'pf_slide_caption_4', array( 'sanitize_callback' => 'pf_sanitize_text_cb' )	);
	$wp_customize->add_setting( 'pf_kb_options_4', array( 'sanitize_callback' => 'pf_sanitize_text_cb' )	);

	$wp_customize->add_setting( 'pf_slide_link_5', array( 'sanitize_callback' => 'pf_sanitize_url_cb' )	);
	$wp_customize->add_setting( 'pf_slide_caption_5', array( 'sanitize_callback' => 'pf_sanitize_text_cb' )	);
	$wp_customize->add_setting( 'pf_kb_options_5', array( 'sanitize_callback' => 'pf_sanitize_text_cb' )	);

	$wp_customize->add_setting( 'pf_timer_speed',
			array(	'default' => '3000',
					'sanitize_callback' => 'pf_sanitize_text_cb'
					)
	);
	$wp_customize->add_setting( 'pf_transition_speed',
		array(	'default' => '1500',
				'sanitize_callback' => 'pf_sanitize_text_cb'
				)
	);
	$wp_customize->add_setting( 'pf_pause_on_hover',
		array (	'default' => 0,
				'sanitize_callback' => 'pf_sanitize_checkbox_cb'
				 )
	);
	$wp_customize->add_setting( 'pf_navigation_arrows',
		array (	'default' => 0,
				'sanitize_callback' => 'pf_sanitize_checkbox_cb'
				 )
	);
	$wp_customize->add_setting( 'pf_slide_number',
		array (	'default' => 0,
				'sanitize_callback' => 'pf_sanitize_checkbox_cb'
				 )
	);
	$wp_customize->add_setting( 'pf_animation',
		array (	'default' => 'fade',
				'sanitize_callback' => 'pf_sanitize_radio_cb'
				 )
	);
	$wp_customize->add_setting( 'pf_slideshow_effect',
		array (	'default' => 'none',
				'sanitize_callback' => 'pf_sanitize_radio_cb'
				 )
	);

	$wp_customize->add_section( 'pf_slideshow_section' , array(
		'title'		 => __( 'Slideshow', 'planet-foundation' ),
		'priority' => 51,
		'description' => __( 'Front page slide show configuration.  Uses Zurb Foundation Orbit javascript plugin.  Overrides Header Image on the front page.', 'planet-foundation') ,
	) );

	$wp_customize->add_control(
		'pf_slideshow_effect',
		array(
			'type' => 'radio',
			'label'=> __( 'Slideshow Effect', 'planet-foundation' ),
			'section'  => 'pf_slideshow_section',
			'priority' => 1,
			'choices'  => array(
				'none'  => 'None',
				'normal'  => 'Normal',
				'kenburns' => 'Ken Burns'
			)
		)
	);

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'pf_slide_1', array(
		'label'=> __( 'Slide 1', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_slide_1',
		'sanitize_callback' => '',
		'priority' => 2
	) ) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'pf_slide_link_1', array(
		'label'=> __( 'Slide Link 1', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_slide_link_1',
		'priority' => 3
	) ) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'pf_slide_caption_1', array(
		'label'=> __( 'Slide Caption 1', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_slide_caption_1',
		'priority' => 3
	) ) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'pf_kb_options_1', array(
		'label'=> __( 'Ken Burns Options 1', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_kb_options_1',
		'priority' => 3
	) ) );
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'pf_slide_2', array(
		'label'=> __( 'Slide 2', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_slide_2',
		'priority' => 4
	) ) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'pf_slide_link_2', array(
		'label'=> __( 'Slide Link 2', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_slide_link_2',
		'priority' => 5
	) ) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'pf_slide_caption_2', array(
		'label'=> __( 'Slide Caption 2', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_slide_caption_2',
		'priority' => 5
	) ) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'pf_kb_options_2', array(
		'label'=> __( 'Ken Burns Options 2', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_kb_options_2',
		'priority' => 5
	) ) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'pf_slide_3', array(
		'label'=> __( 'Slide 3', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_slide_3',
		'priority' => 6
	) ) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'pf_slide_link_3', array(
		'label'=> __( 'Slide Link 3', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_slide_link_3',
		'priority' => 7
	) ) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'pf_slide_caption_3', array(
		'label'=> __( 'Slide Caption 3', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_slide_caption_3',
		'priority' => 7
	) ) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'pf_kb_options_3', array(
		'label'=> __( 'Ken Burns Options 3', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_kb_options_3',
		'priority' => 7
	) ) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'pf_slide_4', array(
		'label'=> __( 'Slide 4', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_slide_4',
		'priority' => 8
	) ) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'pf_slide_link_4', array(
		'label'=> __( 'Slide Link 4', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_slide_link_4',
		'priority' => 9
	) ) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'pf_slide_caption_4', array(
		'label'=> __( 'Slide Caption 4', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_slide_caption_4',
		'priority' => 9
	) ) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'pf_kb_options_4', array(
		'label'=> __( 'Ken Burns Options 4', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_kb_options_4',
		'priority' => 9
	) ) );


	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'pf_slide_5', array(
		'label'=> __( 'Slide 5', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_slide_5',
		'priority' => 10
	) ) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'pf_slide_link_5', array(
		'label'=> __( 'Slide Link 5', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_slide_link_5',
		'priority' => 11
	) ) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'pf_slide_caption_5', array(
		'label'=> __( 'Slide Caption 5', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_slide_caption_5',
		'priority' => 11
	) ) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'pf_kb_options_5', array(
		'label'=> __( 'Ken Burns Options 5', 'planet-foundation' ),
		'section'  => 'pf_slideshow_section',
		'settings' => 'pf_kb_options_5',
		'priority' => 11
	) ) );



	$wp_customize->add_control(
		'pf_animation',
		array(
			'type' => 'radio',
			'label'=> __( 'Animation', 'planet-foundation' ),
			'section'  => 'pf_slideshow_section',
			'priority' => 12,
			'choices'  => array(
				'fade'  => 'Fade',
				'slide' => 'Slide'
			)
		)
	);

	$wp_customize->add_control(
		'pf_pause_on_hover',
		array(
			'type' => 'checkbox',
			'label'=> __( 'Pause on Hover', 'planet-foundation' ),
			'section'  => 'pf_slideshow_section',
			'priority' => 13
		 )
	 );

	$wp_customize->add_control(
		'pf_navigation_arrows',
		array(
			'type' => 'checkbox',
			'label'=> __( 'Navigation Arrows', 'planet-foundation' ),
			'section'  => 'pf_slideshow_section',
			'priority' => 14
		)
	);

	$wp_customize->add_control(
		'pf_slide_number',
		array(
			'type' => 'checkbox',
			'label'=> __( 'Slide Numbers', 'planet-foundation' ),
			'section'  => 'pf_slideshow_section',
			'priority' => 15
		)
	);

	$wp_customize->add_control(
		'pf_timer_speed',
		array(
			'type'				  => 'text',
			'label'				 => __( 'Timer Speed', 'planet-foundation' ),
			'section'		 => 'pf_slideshow_section',
			'sanitize_callback' => 'pf_sanitize_text_cb',
			'priority'		=> 16
		)
	);

	$wp_customize->add_control(
		'pf_transition_speed',
		array(
			'type'				  => 'text',
			'label'				 => __( 'Transition Speed', 'planet-foundation' ),
			'section'		 => 'pf_slideshow_section',
			'sanitize_callback' => 'pf_sanitize_text_cb',
			'priority'		=> 17
		)
	);

	$wp_customize->add_control(
		'pf_transition_speed',
		array(
			'type'				  => 'text',
			'label'				 => __( 'Transition Speed', 'planet-foundation' ),
			'section'		 => 'pf_slideshow_section',
			'sanitize_callback' => 'pf_sanitize_text_cb',
			'priority'		=> 50
		)
	);
	/* End Header Customizer */

	/* Sidebar Customzier */
	$wp_customize->add_section( 'pf_sidebar_section' , array(
		'title'		 => __( 'Sidebars', 'planet-foundation' ),
		'priority'=> 52,
		'description' => 'Choose how sidebars are displayed',
	) );

	$wp_customize->add_setting( 'pf_display_sidebars', array( 'sanitize_callback' => 'pf_sanitize_checkbox_cb' ) );

	$wp_customize->add_control(
		'pf_display_sidebars',
		array(
			'type' => 'checkbox',
			'label'=> __( 'Sidebars on Large', 'planet-foundation' ),
			'section'  => 'pf_sidebar_section',
			'priority' => 13
		)
	);
	/* End Sidebar Customizer */


	/* Favicon Customzier */
	$wp_customize->add_section( 'pf_favicon_section' , array(
		'title'		 => __( 'Favicon', 'planet-foundation' ),
		'priority'=> 12,
		'description' => 'Upload a favicon.  A Favicon is displayed in your pages tab at the top of the web browser.  Should be 16x16 pixel png file.',
	) );

	$wp_customize->add_setting( 'pf_favicon', array( 'sanitize_callback' => 'pf_sanitize_url_cb' ) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'pf_favicon', array(
		'label'=> __( 'Favicon', 'planet-foundation' ),
		'section'  => 'pf_favicon_section',
		'settings' => 'pf_favicon',
	) ) );
	/* End Favicon Customizer */



	$wp_customize->add_section( 'pf_contact_section' , array(
		'title'		 => __( 'Contact', 'planet-foundation' ),
		'priority'=> 53,
		'description' => 'Contact Info.  This will be displayed in the footer unless a widget is placed there.',
	) );
	$wp_customize->add_setting( 'pf_address_name', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_address', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_city', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_state', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_zip', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_country', array( 'sanitize_callback' => 'pf_sanitize_text_cb', 'default' => 'USA' ) );
	$wp_customize->add_setting( 'pf_copyright', array( 'sanitize_callback' => 'pf_sanitize_text_cb', 'default' => '&copy; 2014 [TITLE] -- All rights reserved.' ) );
	$wp_customize->add_setting( 'pf_phone', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_fax', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_email', array( 'sanitize_callback' => 'pf_sanitize_text_cb' ) );
	$wp_customize->add_setting( 'pf_email_page', array( 'sanitize_callback' => 'pf_sanitize_url_cb' ) );
	$wp_customize->add_setting( 'pf_display_theme_author',array ( 'default' => 1, 'sanitize_callback' => 'pf_sanitize_checkbox_cb' ) );

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_address_name',
			array(
				'label'		=> __( 'Address Name', 'planet-foundation' ),
				'section'		  => 'pf_contact_section',
				'settings'		 => 'pf_address_name',
				'type'		 => 'text',
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_address',
			array(
				'label'		=> __( 'Address', 'planet-foundation' ),
				'section'		  => 'pf_contact_section',
				'settings'		 => 'pf_address',
				'type'		 => 'text',
			)
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'pf_city',
			array(
				'label'		=> __( 'City', 'planet-foundation' ),
				'section'		  => 'pf_contact_section',
				'settings'		 => 'pf_city',
				'type'		 => 'text',
		 	)
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Control(
		  $wp_customize,
		  'pf_state',
		  array(
				'label'		=> __( 'State', 'planet-foundation' ),
				'section'		  => 'pf_contact_section',
				'settings'		 => 'pf_state',
				'type'		 => 'text',
		  )
		)
);
	$wp_customize->add_control(
		new WP_Customize_Control(
		  $wp_customize,
		  'pf_zip',
		  array(
				'label'		=> __( 'Zip', 'planet-foundation' ),
				'section'		  => 'pf_contact_section',
				'settings'		 => 'pf_zip',
				'type'		 => 'text',
		  )
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Control(
		  $wp_customize,
		  'pf_country',
		  array(
				'label'		=> __( 'Country', 'planet-foundation' ),
				'section'		  => 'pf_contact_section',
				'settings'		 => 'pf_country',
				'type'		 => 'text',
		  )
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Control(
		  $wp_customize,
		  'pf_copyright',
		  array(
				'label'		=> __( 'Copyright', 'planet-foundation' ),
				'section'		  => 'pf_contact_section',
				'settings'		 => 'pf_copyright',
				'type'		 => 'text',
		  )
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Control(
		  $wp_customize,
		  'pf_pone',
		  array(
				'label'		=> __( 'Phone', 'planet-foundation' ),
				'section'		  => 'pf_contact_section',
				'settings'		 => 'pf_phone',
				'type'		 => 'text',
		  )
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Control(
		  $wp_customize,
		  'pf_fax',
		  array(
				'label'		=> __( 'Fax', 'planet-foundation' ),
				'section'		  => 'pf_contact_section',
				'settings'		 => 'pf_fax',
				'type'		 => 'text',
		  )
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Control(
		  $wp_customize,
		  'pf_email',
		  array(
				'label'		=> __( 'Email', 'planet-foundation' ),
				'section'		  => 'pf_contact_section',
				'settings'		 => 'pf_email',
				'type'		 => 'text',
		  )
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
		  $wp_customize,
		  'pf_email_page',
		  array(
				'label'		=> __( 'Email page', 'planet-foundation' ),
				'section'		  => 'pf_contact_section',
				'settings'		 => 'pf_email_page',
				'type'		 => 'text',
		  )
		)
	);
	$wp_customize->add_control(
		'pf_display_theme_author',
		array(
			'type' => 'checkbox',
			'label'=> __( 'Display Planet Foundation in Footer', 'planet-foundation' ),
			'section'  => 'pf_contact_section',
		)
	);



	$wp_customize->add_section( 'pf_follow_section' , array(
		'title'		 => __( 'Follow Us', 'planet-foundation' ),
		'priority'=> 54,
		'description' => 'Ways to follow and stay in touch',
	) );

  /* Follow Us Customizer */
	$wp_customize->add_setting( 'pf_facebook', array( 'sanitize_callback' => 'pf_sanitize_url_cb' ) );
	$wp_customize->add_setting( 'pf_twitter', array( 'sanitize_callback' => 'pf_sanitize_url_cb' ) );
	$wp_customize->add_setting( 'pf_google_plus', array( 'sanitize_callback' => 'pf_sanitize_url_cb' ) );
	$wp_customize->add_setting( 'pf_youtube', array( 'sanitize_callback' => 'pf_sanitize_url_cb' ) );
	$wp_customize->add_setting( 'pf_email_list', array( 'sanitize_callback' => 'pf_sanitize_url_cb' ) );

	$wp_customize->add_control(
		new WP_Customize_Control(
		  $wp_customize,
		  'pf_facebook',
		  array(
				'label'		=> __( 'Facebook page', 'planet-foundation' ),
				'section'		  => 'pf_follow_section',
				'settings'		 => 'pf_facebook',
				'type'		 => 'text',
		  )
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Control(
		  $wp_customize,
		  'pf_twitter',
		  array(
				'label'		=> __( 'Twitter page', 'planet-foundation' ),
				'section'		  => 'pf_follow_section',
				'settings'		 => 'pf_twitter',
				'type'		 => 'text',
		  )
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Control(
		  $wp_customize,
		  'pf_google_plus',
		  array(
				'label'		=> __( 'Google+ page', 'planet-foundation' ),
				'section'		  => 'pf_follow_section',
				'settings'		 => 'pf_google_plus',
				'type'		 => 'text',
		  )
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Control(
		  $wp_customize,
		  'pf_email_list',
		  array(
				'label'		=> __( 'Email list page', 'planet-foundation' ),
				'section'		  => 'pf_follow_section',
				'settings'		 => 'pf_email_list',
				'type'		 => 'text',
		  )
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Control(
		  $wp_customize,
		  'pf_youtube',
		  array(
				'label'		=> __( 'You Tube channel', 'planet-foundation' ),
				'section'		  => 'pf_follow_section',
				'settings'		 => 'pf_youtube',
				'type'		 => 'text',
		  )
		)
 	);
  /* End Follow Us Customizer */

	/* Other Options Customzier */
	$wp_customize->add_section( 'pf_other_section' , array(
		'title'		 => __( 'Other Options', 'planet-foundation' ),
		'priority'=> 55,
		'description' => 'Other theme options',
	) );

	$wp_customize->add_setting( 'pf_tablet_icons',
		array (	'default' => 0,	'sanitize_callback' => 'pf_sanitize_checkbox_cb' ) );
	$wp_customize->add_setting( 'pf_google_markup',	array (	'default' => 0,	'sanitize_callback' => 'pf_sanitize_checkbox_cb' ) );
	$wp_customize->add_setting( 'pf_facebook_markup', array (	'default' => 0,	'sanitize_callback' => 'pf_sanitize_checkbox_cb' ) );
	$wp_customize->add_setting( 'pf_twitter_markup', array (	'default' => 0,	'sanitize_callback' => 'pf_sanitize_checkbox_cb' ) );


	$wp_customize->add_control(
		'pf_tablet_icons',
		array(
			'type' => 'checkbox',
			'label'=> __( 'Add Icons for Tablets and Phones', 'planet-foundation' ),
			'section'  => 'pf_other_section',
		)
	);
	$wp_customize->add_control(
		'pf_google_markup',
		array(
			'type' => 'checkbox',
			'label'=> __( 'Add Google Schema.org Markup', 'planet-foundation' ),
			'section'  => 'pf_other_section',
		)
	);
	$wp_customize->add_control(
		'pf_facebook_markup',
		array(
			'type' => 'checkbox',
			'label'=> __( 'Add Facebook Open Graph Markup', 'planet-foundation' ),
			'section'  => 'pf_other_section',
		)
	);
	$wp_customize->add_control(
		'pf_twitter_markup',
		array(
			'type' => 'checkbox',
			'label'=> __( 'Add Twitter Markup', 'planet-foundation' ),
			'section'  => 'pf_other_section',
		)
	);
	/* End Other Options Customizer */

	/**
	 * Action hook pf_extend_customizer
	 * 
	 * Allows child themes to add more options to the menus for more custom configuration of theme
	 *
	 * @since Planet Foundation 1.0.0
	 */
	do_action('pf_extend_customizer');
}
add_action('customize_register', 'pf_theme_customizer');


/**
 * Callback to use to ensure a field is purely text with
 * no html or evil scripts.
 *
 * @since Planet Foundation 1.0.0
 *
 * @param string $input String in a text field of the customizer
 *
 * @return string Text field stripped of html and evil things
 *
 */
function pf_sanitize_text_cb( $input ) {
  return wp_kses( $input, '' );
}

/**
 * Callback to that sanitizes a field containing a URL
 *
 * Filters out any evil scripts
 *
 * @since Planet Foundation 1.0.0
 *
 * @param string $url The url to santize
 *
 */
function pf_sanitize_url_cb( $url ) {
  return esc_url( $url );
}

/**
 * Callback to sanitize checkboxes
 *
 * @since Planet Foundation 1.0.0
 *
 * @link http://themefoundation.com/wordpress-theme-customizer/ Tutorial on Customization and Sanitation
 *
 * @param int $input Should be 1 or 0 for a checkbox
 *
 * @return int 1 or 0
 *
 */
function pf_sanitize_checkbox_cb( $input ) {
	if ( $input == 1 ) {
		return 1;
	} else {
		return 0;
	}
}

/**
 * Callback to sanitize all radio button settings before entry into the database
 *
 * @since Planet Foundation 1.0.0
 *
 * @link http://themefoundation.com/wordpress-theme-customizer/ Tutorial on Customization and Sanitation
 *
 * @param array $input An array representing a radio control setting
 *
 * @return array|null If valid array is found, $input is returned
 *
 */
function pf_sanitize_radio_cb ( $input ) {
	$valid = array(
		'fade' => 'Fade',
    'slide' => 'Slide',
		'normal' => 'Normal',
		'kenburns' => 'Ken Burns',
		'none' => 'None'
	);
 
	if ( array_key_exists( $input, $valid ) ) {
		return $input;
	} else {
		return '';
	}

}


?>