<?php
/**
 * Configuration of background colors for different regions
 *
 * @since Planet Foundation 1.0.0
 * @package ncp\wp\themes\planet_foundation
 *
 */

/**
 * Checks theme customization and adds css styling to header for background colors
 *
 * Adds html directly to UA.  Uses the hook pf_add_more_background_colors.
 * Hooks are called before ending </style> is printed.
 *
 * @since Planet Foundation 1.0.0
 *
 * @see http://codex.wordpress.org/Function_Reference/get_theme_mod get_theme_mod()
 * @see http://codex.wordpress.org/Function_Reference/do_action do_action()
 * @see http://codex.wordpress.org/Function_Reference/add_action add_action()
 * @link http://codex.wordpress.org/Theme_Customization_API Theme Customization API
 *
 */
function pf_add_background_colors() {
	?>
	<style type="text/css" media="screen">

	<?php

	if ( $pre_header_bg_color = get_theme_mod( 'pf_pre_header_bg_color' ) ) {
	?>
		#pf-pre-header  {
			background-color: <?php echo esc_attr( $pre_header_bg_color ); ?>
		}
	<?php
	}

	if ( $main_content_bg_color = get_theme_mod( 'pf_main_content_bg_color' ) ) {
	?>
		#pf-main-content-container-column {
			background-color: <?php echo esc_attr( $main_content_bg_color ); ?>;
		}
	<?php
	}

	if ( $footer_bg_color = get_theme_mod( 'pf_footer_bg_color' ) ) {
	?>
		#pf-footer  {
			background-color: <?php echo esc_attr( $footer_bg_color ); ?>;
		}
	<?php
	}

	if ( $navigation_menu_bg_color = get_theme_mod( 'pf_navigation_bg_color' ) ) {
	?>
		#pf-topbar-container-column nav,
		#pf-topbar-container-column nav a,
		#pf-topbar-container-column nav ul,
		#pf-topbar-container-column .contain-to-grid {
			background-color: <?php echo esc_attr( $navigation_menu_bg_color ); ?>
		}
	<?php
	}

	if ( $page_menu_bg_color = get_theme_mod( 'pf_page_menu_bg_color' ) ) {
	?>
		nav#pf-page-menu {
			background-color: <?php echo esc_attr( $page_menu_bg_color ); ?>
		}
	<?php
	}

	if ( $right_sidebar_bg_color = get_theme_mod( 'pf_right_sidebar_bg_color' ) ) {
	?>
		aside.pf-right-sidebar, .pf-right-sidebar {
			background-color: <?php echo esc_attr( $right_sidebar_bg_color ); ?>;
		}
	<?php
	}

  if ( $left_sidebar_bg_color = get_theme_mod( 'pf_left_sidebar_bg_color' ) ) {
  ?>
     aside.pf-left-sidebar, .pf-left-sidebar  {
        background-color: <?php echo esc_attr( $left_sidebar_bg_color ); ?>;
     }
	<?php
	}
	/**
	 * Action hook pf_add_more_background_colors.
	 * 
	 * Allows child themes to add more styling here.  Styling added before
	 * the </style> tag is printed.
	 *
	 * @since Planet Foundation 1.0.0
	 */
	do_action( 'pf_add_more_background_colors' );    
	?>
	</style>
	<?php
}
add_action( 'wp_head', 'pf_add_background_colors' );


/*
 * Add colors for wordpress editor
 *
function pf_add_admin_bg_colors() {
	if ( $main_content_bg_color = get_theme_mod( 'pf_main_content_bg_color' ) ) {
	?>
	<style>
		body .mceContentBody {
			background-image: none;
			background-color: <?php echo esc_attr( $main_content_bg_color ); ?>;
		}
	</style>
	<?php
	}
}
add_action( 'admin_head', 'pf_add_admin_bg_colors' );
*/

/**
 * Modification of _custom_background_cb to only use background image on large screen devices only.
 *
 * Large screen devices hardcoded here to be 768 pixels.
 *
 * Prints the html directly to UA
 *
 * @todo Figure out how to use the Zurb Foundation SASS parameter
 * @todo Figure out if this is even necessary.  Small devices may not even load the background.
 *
 * @see http://codex.wordpress.org/Function_Reference/get_theme_mod get_theme_mod()
 *
 */
function pf_custom_background_cb() {
	// $background is the saved custom image, or the default image.
	$background = set_url_scheme( get_background_image() );

	// $color is the saved custom color.
	// A default has to be specified in style.css. It will not be printed here.
	$color = get_theme_mod( 'background_color' );

	if ( ! $background && ! $color )
		return;

	$style = $color ? "background-color: #$color; " : '';

	if ( $background ) {
		$image = " background-image: url('$background');";

		$repeat = get_theme_mod( 'background_repeat', 'repeat' );
		if ( ! in_array( $repeat, array( 'no-repeat', 'repeat-x', 'repeat-y', 'repeat' ) ) )
			$repeat = 'repeat';
		$repeat = " background-repeat: $repeat;";

		$position = get_theme_mod( 'background_position_x', 'left' );
		if ( ! in_array( $position, array( 'center', 'right', 'left' ) ) )
			$position = 'left';
		$position = " background-position: top $position;";

		$attachment = get_theme_mod( 'background_attachment', 'scroll' );
		if ( ! in_array( $attachment, array( 'fixed', 'scroll' ) ) )
			$attachment = 'scroll';
		$attachment = " background-attachment: $attachment;";

		$style .= $image . $repeat . $position . $attachment;
                
	}
?>
<style type="text/css" id="custom-background-css">
@media only screen and (min-width: 768px) {
body.custom-background { <?php echo trim( $style ); ?> }
}
</style>
<?php
}

?>
