<?php
/**
 * This generates the <head>, pre-header, header images, slideshows, and main navigation 
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0
 */

 $phpdocs_hack=0; // Forcing phpdocs parser to work. Yuck!

?>

<!doctype html>
<!-- paulirish.com/2008/conditional-stylesheets-vs-css-hacks-answer-neither/ -->
<!--[if lt IE 7]> <html class="no-js ie6 oldie" <?php language_attributes(); ?> > <![endif]-->
<!--[if IE 7]>    <html class="no-js ie7 oldie" <?php language_attributes(); ?> > <![endif]-->
<!--[if IE 8]>    <html class="no-js ie8 oldie" <?php language_attributes(); ?> "> <![endif]-->
<!-- Consider adding an manifest.appcache: h5bp.com/d/Offline -->
<!--[if gt IE 8]><!--> <html class="no-js" <?php language_attributes(); ?> > <!--<![endif]-->
<head>
	<meta charset="<?php bloginfo('charset'); ?>">

	<title><?php wp_title(''); ?></title>

	<?php $google_markup = get_theme_mod( 'pf_google_markup' ); ?>

	<?php if( is_singular() ) : ?>
		<?php global $wp_query; ?>
		<?php while ( have_posts() ) : the_post(); ?>
			<?php	$title = ltrim( wp_title( '', false ) ); ?>
			<?php $description = get_the_excerpt(); ?>
			<?php $site_name = get_bloginfo( 'name' ); ?>
			<?php $thumbnail_id = get_post_thumbnail_id( get_the_ID() ); ?>
			<?php $thumbnail_url = wp_get_attachment_url( $thumbnail_id ); ?>
			<?php if ( ! $thumbnail_url ) : ?>
				<?php $thumbnail_url = pf_get_header_url(); ?>
			<?php endif; ?>
			<?php $author = get_the_author_meta('googleplus'); ?>
			<?php if( !$author) : ?>
				<?php $author = get_the_author_meta('url'); ?>
			<?php endif; ?>
			<?php break; ?>
		<?php endwhile; ?>
		<?php rewind_posts(); ?>

		<?php if( $fb_markup = get_theme_mod( 'pf_facebook_markup' ) ) : ?>
			<!-- Open Graph Markup for Facebook -->
			<meta property="og:title" content="<?php echo $title; ?>" />
			<meta property="og:description" content="<?php echo $description; ?>" />
			<meta property="og:site_name" content="<?php bloginfo('name'); ?>" />
			<meta property="og:image" content="<?php echo $thumbnail_url; ?>" />
		<?php endif; ?>

		<?php if( $google_markup ) : ?>
			<!-- Schema.org Markup for Google+ -->
			<meta itemprop="name" content="<?php echo $title; ?>" />
			<meta itemprop="description" content="<?php echo $description; ?>" />
			<meta itemprop="image" content="<?php echo $thumbnail_url; ?>" />

			<!-- Authorship for Google -->
			<?php if( $author ) : ?>
				<?php $author = "$author?rel=author"; ?>
				<link rel="author" href="<?php echo $author; ?>" />
			<?php endif; ?>
		<?php endif; ?>

		<?php if( $twitter_markup = get_theme_mod( 'pf_twitter_markup' ) ) : ?>
			<!-- Twitter Card data -->
			<meta name="twitter:card" content="summary"> 
			<meta name="twitter:title" content="<?php echo $title; ?>"> 
			<meta name="twitter:description" content="<?php echo $description; ?>"> 
			<meta name="twitter:image" content="<?php echo $thumbnail_url; ?>">
		<?php endif; ?>
	<?php endif; ?>

	<?php if( $google_markup ) : ?>
		<!-- Publisher for Google -->
		<?php if( $publisher = get_theme_mod( 'pf_google_plus' ) ) : ?>
			<link rel="publisher" href="<?php echo $publisher; ?>" />
		<?php endif; ?>
	<?php endif; ?>

	<!-- Mobile viewport optimized: j.mp/bplateviewport -->
	<meta name="viewport" content="width=device-width" />

	<?php if ( $favicon = get_theme_mod( 'pf_favicon' ) ) : ?>
		<!-- Favicon and Feed -->
		<link rel="shortcut icon" type="image/png" href="<?php echo $favicon; ?>" />
	<?php endif; ?>

	<?php if ( $tablet_icons = get_theme_mod( 'pf_tablet_icons' ) ) : ?>
		<!-- Icons for tablets and smart phones -->
		<link href="<?php echo get_template_directory_uri(); ?>/img/pf-touch-icon-60x60.png" rel="apple-touch-icon" />
		<link href="<?php echo get_template_directory_uri(); ?>/img/pf-touch-icon-76x76.png" rel="apple-touch-icon" sizes="76x76" />
		<link href="<?php echo get_template_directory_uri(); ?>/img/pf-touch-icon-120x120.png" rel="apple-touch-icon" sizes="120x120" />
		<link href="<?php echo get_template_directory_uri(); ?>/img/pf-touch-icon-152x152.png" rel="apple-touch-icon" sizes="152x152" />
	<?php endif; ?>

<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<!-- Start the main container -->
	<div id="pf-page-container" class="">
		<div class="">
			<section class="container" role="document">

				<?php $header = pf_get_the_header(); ?>
				<?php $header = apply_filters('pf_header', $header);  // allow child themes to modify ?>
				<?php $pre_header_first = get_theme_mod( 'pf_pre_header_first' ); ?>
				<?php if ( !$header && !$pre_header_first) : ?>
					<?php pf_the_nav_menu() ?>
				<?php endif; ?>

				<div id="pf-pre-header" class="row">

					<?php if ( !is_active_sidebar( 'pre-header' ) ) : ?>

						<?php $is_pre_header = get_theme_mod( 'pf_pre_header_on_home_page' ); ?>

						<?php if ( ( $is_pre_header == '1' && is_front_page() ) || !is_front_page() ) : ?>

						<?php if ( $pf_logo = get_theme_mod( 'pf_logo' ) ) : ?>
							<div id="pf-logo-column" class="large-2 medium-3 columns">
								<div class="show-for-medium-up site-logo">
									<a href='<?php echo esc_url( home_url( '/' ) ); ?>' title='<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>' rel='home'><img alt="Site Logo" id="pf-logo" src='<?php echo esc_url( $pf_logo ); ?>' alt='<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>'></a>
								</div>
							</div>
						<?php endif; ?>


						<?php if ($pf_logo) : ?>
							<div id="pf-title-and-description-column" class="large-10 medium-9 columns">
						<?php else: ?>
							<div id="pf-title-and-description-column" class="small-12 columns">
						<?php endif; ?>
							<h1 class="site-title"><?php bloginfo( 'name' ); ?></h1>
							<h2 class="subheader site-description"><?php bloginfo( 'description' ); ?></h2>
							<?php if ( $sub_tagline = get_theme_mod( 'pf_sub_tagline' ) ) : ?>
								<p class="pf-sub-tagline"><?php echo $sub_tagline; ?></p>
							<?php endif; ?>
							</div>
					<?php endif; ?>
					<?php else: ?>
						<?php dynamic_sidebar( 'Pre-header' ); ?>
		      <?php endif; ?>

				</div><!-- #pf-pre-header -->

			<?php if ( $header || $pre_header_first) : ?>
				<?php pf_the_nav_menu() ?>
			<?php endif; ?>

			<?php if ( $header ) : ?>
				<div class="row">         
					<div id="pf-banner-container-column" class="large-12 columns">
						<?php echo $header ?>
					</div><!-- End pf-banner-container-column -->
				</div><!-- End pf-banner-container row -->

			<?php endif; ?>
