<?php
/**
 *
 * The brains behind this theme.  Start here to figure things out.
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0
 */

// Load cleaner
require_once('lib/clean.php');

// Enqueue styles
require_once('lib/styles.php'); 

// Load pagination
require_once('lib/pagination.php');

// Load navigation
require_once('lib/navigation.php');

// Load Theme Customizer
require_once('lib/customizer.php');

// Clearing Lightbox Integration
require_once('lib/lightbox.php');

// Load helper functions
require_once('lib/utilities.php');

// Widget registration
require_once( 'lib/widgets.php' );

// Font Configuration
require_once( 'lib/fonts.php' );

// Background Color Configuration
require_once( 'lib/colors.php' );

// Load Theme Supports
require_once( 'lib/supports.php' );

// Add Foundation Styles to the TinyMCE Editor
require_once( 'lib/mce.php' );

// Add custom meta boxes and fields
require_once( 'lib/metaboxes.php' );

// Add Ken Burns Support
require_once( 'lib/ken-burns.php' );

// Add messaging
require_once( 'lib/messages.php' );


/**
 * Adds another image size to the media upload options
 *
 * @return void
 */
function pf_add_image_size() {
 add_image_size( 'thumbnail-large', 300, 300, true);
}
add_action( 'init', 'pf_add_image_size' );

/**
 * Adds custom size to media editor
 *
 * @param $sizes size of custom thumbnail
 * @return array Modified size array
 */
function pf_add_custom_image_to_media ( $sizes ) {
    return array_merge( $sizes, array(
        'thumbnail-large' => __('A Good Featured Size', 'planet-foundation' ),
    ) );
}
add_filter( 'image_size_names_choose', 'pf_add_custom_image_to_media' );

/**
 *
 * Adds itemscope for schema.org
 *
 * @param string $output lanaguage attributes for page or post so far
 *
 * @return string itemscope for schema.org
 */
function pf_add_schema_org_doctype( $output ) {
  if ( is_singular() )
	  return $output . ' itemscope itemtype="http://schema.org/Article"';

	return $output;
}
add_filter('language_attributes', 'pf_add_schema_org_doctype');

// Allows shortcodes in widgets
add_filter('widget_text', 'do_shortcode');

/**
 *
 * For custom home pages when wp_title does not return anything
 *
 * @param string $title Title generated for page or post so far
 *
 * @return string $title Title for page
 */
function pf_baw_hack_wp_title_for_home( $title )
{
  if( empty( $title ) && ( is_home() || is_front_page() ) ) {
		$name = get_bloginfo( 'name' );
		$desc = get_bloginfo( 'description' );
		if ( $name && $desc )
	    return $name . ' | ' . $desc;
		else if ($name)
	    return $name;
		else if ($desc)
	    return $desc; 
  }
  return "$title | " . get_bloginfo('name');
}
add_filter( 'wp_title', 'pf_baw_hack_wp_title_for_home' );

/**
 *
 * Load foundation libraries
 *
 */
function pf_load_foundation() {
?>

<script>
	(function($) {
		$(document).foundation();
	})(jQuery);
</script>

<?php
}
add_action( 'wp_footer', 'pf_load_foundation',  10000);

