<?php
/**
 * Template for footer.
 *
 * This is used to generate the html for the footer at the bottom
 * of all pages.  Will use widgets first if they have been configured, otherwise will
 * use the information specified in the theme customization including Address and Follow Us
 * info
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0
 */

echo '</section><!-- Container End -->'; ?>


<footer id="pf-footer" class="row" role="contentinfo">
  <?php if ( is_active_sidebar( 'footer' ) ) : ?>
    <div class="large-12 columns">
      <?php dynamic_sidebar( 'footer' ); ?>
    </div>
  <?php else : ?>
    <div itemscope itemtype="http://schema.org/Organization">

      <div class="large-4 columns">

        <?php
          $address = get_theme_mod( 'pf_address' );
          $phone = get_theme_mod( 'pf_phone' );

          $fax = get_theme_mod( 'pf_fax' );
          $city = get_theme_mod( 'pf_city' );
          $zip = get_theme_mod( 'pf_zip' );
          $state = get_theme_mod( 'pf_state' );
          $country = get_theme_mod( 'pf_country', 'USA' );
          $email = get_theme_mod( 'pf_email' );
          $email_page = get_theme_mod( 'pf_email_page' );
          $title = get_bloginfo( 'name', 'display' );
          $title = get_theme_mod( 'pf_address_name', $title );
          $logo = get_theme_mod( 'pf_logo' );
          $url = home_url('/');
          $copyright = get_theme_mod( 'pf_copyright', '&copy; 2014 [TITLE] -- All rights reserved.' );
		  $copyright = str_replace( '[TITLE]', esc_attr( $title ), $copyright );

          $google_plus = get_theme_mod( 'pf_google_plus' );
          $facebook = get_theme_mod( 'pf_facebook' );
          $twitter = get_theme_mod( 'pf_twitter' );
          $email_list = get_theme_mod( 'pf_email_list' );
          $youtube = get_theme_mod( 'pf_youtube' );
          $author = get_theme_mod( 'pf_display_theme_author', '1' );
        ?>

        <h5 class="pf-footer-title"><?php _e('Address','planet-foundation'); ?></h5>
        <?php if ( $logo ) : ?><meta itemprop="logo" content="<?php echo $logo; ?>" /><?php endif; ?><meta itemprop="url" content="<?php echo $url; ?>" /><p><span itemprop="name"><?php echo esc_attr( $title ); ?></span><?php if ( $address ) : ?>, <span itemscope itemtype="http://schema.org/PostalAddress"><span itemprop="streetAddress"><?php echo esc_attr( $address ); ?></span><?php endif; if ( $city ) : ?>, <span itemprop="addressLocality"><?php echo esc_attr( $city ); ?></span><?php endif; if ( $state ) : ?>, <span itemprop="addressRegion"><?php echo esc_attr( $state ); ?></span><?php endif; if ($zip) : ?> <span itemprop="postalCode"><?php echo esc_attr( $zip ); ?></span><?php endif; if ( $country ) : ?> <span itemprop="addressCountry"><?php echo esc_attr( $country ); ?></span><?php endif; ?></span></p>
       <?php if( $copyright ) : ?><p><?php echo esc_attr( $copyright ); ?></p><?php endif; ?>
				<?php if( $author ) : ?>
       <p><?php _e('Site Theme','planet-foundation'); ?>: <a title="WordPress Theme Planet Foundation" href="http://www.norcalplanet.com/planet-foundation"><?php _e('Planet Foundation','planet-foundation'); ?></a></p>
				<?php endif; ?>
    </div><!-- End footer column 1 -->

    <div class="large-4 columns">
      <h5 class="pf-footer-title"><?php _e('Contact Us', 'planet-foundation'); ?></h5>
			<?php if( ! $fax ) : ?>
	      <p itemprop="telephone"><?php echo esc_attr( $phone ); ?></p>
			<?php else : ?>
	      <p style="margin-bottom:0px;"><?php _e('Phone','planet-foundation'); ?>: <span itemprop="telephone"><?php echo esc_attr( $phone ); ?></span></p>
	      <p><?php _e('Fax','planet-foundation'); ?>: <span itemprop="faxNumber"><?php echo esc_attr( $fax ); ?></span></p>
			<?php endif; ?>
	      <?php if( $email ) : ?><p class="pf-email"><a itemprop="email"><?php echo esc_attr( $email ); ?></a></p><?php endif; ?>
      <?php if ( $email_page ) : ?><a title="Send us and email" href="<?php echo esc_url( $email_page ); ?>" class="tiny button"><?php _e('Email Us','planet-foundation'); ?></a><?php endif; ?>
    </div><!-- End footer column 2 -->

    <div class="large-4 columns">
      <h5 class="pf-footer-title"><?php _e('Stay in Touch','planet-foundation'); ?></h5>
      <ul class="inline-list">
				<?php if ( $facebook ) : ?>
	        <li><a href="<?php echo esc_url( $facebook ); ?>"><img alt="Facebook Logo" title="Follow Us on Facebook" src="<?php echo get_template_directory_uri(); ?>/img/facebook_50.png" /></a></li>
				<?php endif; ?>
				<?php if ( $twitter ) : ?>
	        <li><a href="<?php echo esc_url( $twitter ); ?>"><img alt="Twitter Logo" title="Follow Us on Twitter" src="<?php echo get_template_directory_uri(); ?>/img/twitter_50.png" /></a></li>
				<?php endif; ?>
				<?php if ( $email_list ) : ?>
	        <li><a href="<?php echo esc_url( $email_list ); ?>"><img title="Subscribe to Our Email List" alt="Email logo" src="<?php echo get_template_directory_uri(); ?>/img/email_50.png" /></a></li>
				<?php endif; ?>
				<?php if( $google_plus ) : ?>				
	        <li><a href="<?php echo esc_url( $google_plus ); ?>"><img title="Follow Us on Google+" alt="Google+ icon" src="<?php echo get_template_directory_uri(); ?>/img/google_50.png" /></a></li>
				<?php endif; ?>
        <li><a href="/rss"><img title="Subscribe to Our Blog" alt="RSS logo" src="<?php echo get_template_directory_uri(); ?>/img/rss_50.png" /></a></li>
				<?php if( $youtube ) : ?>
	        <li><a href="<?php echo esc_url( $youtube ); ?>"><img title="Subscribe to Our You Tube Channel" alt="YouTube logo" src="<?php echo get_template_directory_uri(); ?>/img/youtube_50.png" /></a></li>
				<?php endif; ?>

      </ul>
    </div><!-- End footer column 3 -->

    </div><!-- End organization schema div -->

  <?php endif; ?>


  </footer>


</div><!-- pf-page-container columns -->
</div><!-- #pf-page-container -->

<?php wp_footer(); ?>	



</body>
</html>