<?php
/**
 * Default template for used to display excerpts in archives and other lists
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0
 */

 $phpdoc_hack=0;  // parser won't parse summary without some code
?>


<article id="post-<?php the_ID(); ?>" <?php post_class( 'row pf-excerpt' ) ?>>

  <div class="entry-content">

      <?php if ( has_post_thumbnail() && ! post_password_required() ) : ?>
        <div class="medium-3 large-4 columns entry-thumbnail">
          <?php the_post_thumbnail(); ?>
        </div>
        <div class="medium-9 large-8 columns">
      <?php else : ?>
        <div class="large-12 columns">
	  <?php endif; ?>

        <header>
          <h2 class="entry-title"><a rel="bookmark" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
        </header>
        <div class="entry-summary">

            <?php the_excerpt(); ?>
						<a href="<?php the_permalink(); ?>" class="tiny button">Read More</a>

        </div>
        <footer>
		  <hr />
          <p class="entry-meta pf-author-date-container">
						<?php $posted_text = __('Posted','planet-foundation') . ':'; ?>
            <?php echo pf_get_the_author( $posted_text ); ?> | <?php echo pf_get_the_date( '', 'short' ); ?></p>
          </p>
        </footer>
      </div>
  </div>

</article><!-- #post -->

<hr />