<?php
/**
 * Template for used to display excerpts for video post formats
 *
 * Gonna use the the default here for lack of anything fancier to do.
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0.0
 */

 $phpdoc_hack=0;  // parser won't parse summary without some code
?>


<article id="post-<?php the_ID(); ?>" <?php post_class( 'row pf-excerpt' ) ?>>

	<div class="entry-content">

		<div class="large-12 columns">

			<header>
				<h2 class="entry-title"><a rel="bookmark" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
			</header>
			<div class="entry-summary">
				<?php
          /**
           * Adds flex video wrapper around video
           *
           * @param string $content
           *
           */
					function pf_add_flex_video_excerpt($content) {
						$pattern = '~<iframe.*</iframe>|<embed.*</embed>~';
						preg_match_all($pattern, $content, $matches);
						foreach ($matches[0] as $match) {
							$wrappedframe = '<div class="flex-video">' . $match . '</div>';
							return $wrappedframe;
						}
						return $content;    
					}

					add_filter('the_content', 'pf_add_flex_video_excerpt');
					the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'planet-foundation' ) );
					remove_filter('the_content','pf_add_flex_video_excerpt');
				?>
			</div>
	        <footer>
				<hr />
		        <p class="entry-meta pf-author-date-container">
					<?php $posted_text = __('Posted','planet-foundation') . ':'; ?>
					<?php echo pf_get_the_author( $posted_text ); ?> | <?php echo pf_get_the_date( '', 'short' ); ?></p>
			    </p>
			</footer>
		</div>
	</div>

</article><!-- #post -->

<hr />


