<?php
/**
 * Template for used to display the summary of a status post.
 *
 * For posts set to the post format Status, this template is used whenever
 * a list of posts is displayed.  This is called within the loop.  This
 * implementation has no link to the full article as an status implies 
 * short and sweet.
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0
 */

  $post_classes = get_post_class();
  $post_classes = pf_remove_hentry_class( $post_classes, 'row pf-excerpt');
?>

<article id="post-<?php the_ID(); ?>" class="<?php echo $post_classes; ?>">

	<?php
		$display_sidebars = get_theme_mod( 'pf_display_sidebars' );
		$left_sidebar = is_active_sidebar( 'left' );
		$right_sidebar = is_active_sidebar( 'primary' );
	?>

	<?php if ( !( $display_sidebars && $left_sidebar && $right_sidebar ) ) : ?>
		<div class="hide-for-small medium-2 large-1 columns">
			<div class="hide-for-small link-icon">
				<img src="<?php echo get_template_directory_uri(); ?>/img/status.png" />
			</div>
		</div><!-- .medium-2, etc. -->
	<?php endif; ?>

	<?php if ( !( $display_sidebars && $left_sidebar && $right_sidebar ) ) : ?>
		<div class="medium-10 large-11 columns">
	<?php else : ?>
		<div class="large-12 columns">
	<?php endif; ?>
	<?php $content = get_the_content(); ?>
	<div class="panel callout">
		<div class="entry-content">
			<p><?php echo $content; ?> - <?php echo pf_get_the_author( '' ); ?> | <?php echo pf_get_the_date('','short'); ?></p>
		</div>
	</div>

	</div><!-- .small-9, etc. -->

<hr />
</article><!-- #post -->


