<?php
/**
 * Template for used to display the summary of a link post.
 *
 * For posts set to th post format Link, this template is used whenever
 * a list of posts is displayed.  This is called within the loop.
 *
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0
 */

  $post_classes = get_post_class();
  $post_classes = pf_remove_hentry_class( $post_classes, 'row pf-excerpt');
?>		

<article id="post-<?php the_ID(); ?>" class="<?php echo $post_classes; ?>">

	<?php
		$display_sidebars = get_theme_mod( 'pf_display_sidebars' );
		$left_sidebar = is_active_sidebar( 'left' );
		$right_sidebar = is_active_sidebar( 'primary' );
	?>

	<?php if ( !( $display_sidebars && $left_sidebar && $right_sidebar ) ) : ?>
		<div class="hide-for-small medium-2 large-1 columns">
			<div class="link-icon">
				<img src="<?php echo get_template_directory_uri(); ?>/img/link.png" />
			</div>
		</div>
  <?php endif; ?>

	<?php if ( !( $display_sidebars && $left_sidebar && $right_sidebar ) ) : ?>
		<div class="medium-10 large-11 columns">
	<?php else : ?>
		<div class="large-12 columns">
	<?php endif; ?>
	<div class="panel">
		<?php the_content(); ?>
	</div>

	<footer class="entry-meta">
		<?php // Add Add-to-Any links if plugin is installed ?>
			<?php if( function_exists( 'ADDTOANY_SHARE_SAVE_KIT' ) ) : ?>
				<div class="pf-add-to-any">
					<?php ADDTOANY_SHARE_SAVE_KIT( array("linkname" => get_the_title(), "linkurl" => get_permalink()) ); ?>
				</div>
				<p class="pf-author-date-container">
					<?php echo pf_get_the_author( 'Posted:' ); ?> | <?php echo pf_get_the_date( '', 'short' ); ?></p>
				</p>
		<?php endif; ?>
	</footer>

	</div>

<hr />
</article>



