<?php
/**
 * Template for used to display excerpts for image post formats
 *
 * For posts set to the post format Image, this template is used whenever
 * a list of posts is displayed.  This is called within the loop.
 * 
 * @package ncp\wp\themes\planet_foundation
 * @since Planet Foundation 1.0
 */

  // remove hentry class
  // We do this because there is no author info to go with the hentry.
  $post_classes = get_post_class();
  $post_classes = pf_remove_hentry_class( $post_classes, 'row pf-excerpt');
?>

<article id="post-<?php the_ID(); ?>" class="<?php echo $post_classes; ?>">

	<div class="entry-content">

		<div class="large-12 columns">

			<header>
				<h2 class="entry-title"><a rel="bookmark" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
			</header>


				<div class="entry-summary pf-excerpt-image-container">
					<?php if ( has_post_thumbnail() && ! post_password_required() ) : ?>
						<a title="Click to view full post" href="<?php the_permalink(); ?>"><?php the_post_thumbnail('full'); ?></a>
					<?php elseif ( $img = pf_get_first_image() ) : ?>
						<a title="Click to view full post" href="<?php the_permalink(); ?>"><?php echo $img; ?></a>
					<?php else : ?>
						<p><?php _e( 'This is an image post.  Put an image in your content or set your featured image', 'planet-foundation' ); ?></p>
					<?php endif; ?>

				</div>
		        <footer>
					<hr />
			        <p class="entry-meta pf-author-date-container">
						<?php $posted_text = __('Posted','planet-foundation') . ':'; ?>
						<?php echo pf_get_the_author( $posted_text ); ?> | <?php echo pf_get_the_date( '', 'short' ); ?></p>
				    </p>
				</footer>

		</div>

	</div>

<hr />      
</article><!-- #post -->

