<?php
/**
 * Template for used to display excerpts for gallery post formats
 *
 * For posts set to the post format Gallery, this template is used whenever
 * a list of posts is displayed.  This is called within the loop.  First few
 * images of the gallery are displayed here as thumbnails
 * 
 * @since Planet Foundation 1.0.0
 *
 * @package ncp\wp\themes\planet_foundation
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 */

  // remove hentry class
  // We do this because there is no author info to go with the hentry.
  $post_classes = get_post_class();
  $post_classes = pf_remove_hentry_class( $post_classes, 'row pf-excerpt');
?>

<article id="post-<?php the_ID(); ?>" class="<?php echo $post_classes; ?>">

	<div class="entry-content">

		<div class="large-12 columns">

			<header class="entry-header">
				<h2 class="entry-title"><a rel="bookmark" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
			</header>

			<div class="entry-content">
				<?php $gallery = get_post_gallery(get_the_ID(), false); ?>
					<?php if ( ! $gallery ) : ?>
						<p><?php _e('Post is marked as a gallery but no gallery found','planet-foundation'); ?></p>
					<?php else : ?>
						<a title="Click to view full gallery" href="<?php the_permalink(); ?>"><div class="pf-excerpt-gallery-container">
						<?php
							// Loop through images, output the first 6
							$i=0;
							foreach( $gallery['src'] as $src ) {
								echo '<img src="' . esc_url( $src ) . '" class="pf-excerpt-gallery-image pf-excertp-gallery-image-' . $i . '" alt="Gallery image" />';
								if ( ++$i == 6) break;
							}
						?>
						</div></a><!-- .pf-excerpt-gallery-container -->
					<?php endif; ?>
				</div>


	</div>

	<hr />
</article><!-- #post -->

