<?php
/**
 * Template for used to display full content of posts 
 *
 * Called within the loop of single.php and the like
 *
 * @since Planet Foundation 1.0.0
 *
 * @package ncp\wp\themes\planet_foundation
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 */

$post_classes = get_post_class( 'pf-full-post' );
if ( ! pf_show_author() )
	$post_classes = pf_remove_hentry_class( $post_classes, '');
else 
	$post_classes = implode( ' ', $post_classes );
?>

<article id="post-<?php the_ID(); ?>" class="<?php echo $post_classes; ?>">

	<?php if( pf_show_title() ) : ?>
		<header class="entry-header row">
			<div class="large-12 columns">
				<?php if ( current_user_can( 'edit_posts' ) ) : ?>
					<h2 class="pf-edit-post entry-title"><?php the_title(); ?></h2>
				<?php else: ?>
					<h2 class="entry-title"><?php the_title(); ?></h2>
				<?php endif; ?>

				<div class="entry-meta pf-edit-post-link-container">
					<?php if ( !is_page() ) : ?>
						<?php edit_post_link( __( 'Edit Post', 'planet-foundation' ) ); ?>
					<?php else : ?>
						<?php edit_post_link( __( 'Edit Page', 'planet-foundation' ) ); ?>
					<?php endif; ?>
				</div>
				<hr />
			</div>
		</header><!-- .entry-header -->
	<?php endif; ?>

	<div class="entry-content row">

	<?php
		// utilizing a custom field for displaying additional images.
		global $pf_metabox_optional_images;
		$meta = $pf_metabox_optional_images->the_meta();

		if ( $meta && $meta['images'] ) {
			echo '<div class="hide-for-small medium-3 large-4 columns">';

	?>

	<?php
    if ( $meta && $meta['images'] ) {
		global $wpdb;
		$optional_images = $meta['images'];
		foreach( $optional_images as $key => $optional_image ) {
			$optional_image_url = $optional_image['imgurl'];
			$query = "SELECT ID FROM {$wpdb->posts} WHERE guid='$optional_image_url'";
			$attachment_id = $wpdb->get_var($query);
			$attachment = get_post( $attachment_id );
			$optional_image_url = wp_make_link_relative( $optional_image_url );
			$post_img_alt = get_post_meta($attachment->ID, '_wp_attachment_image_alt', true);
			$post_img_title = $attachment->post_excerpt;
	?>
		<figure class="pf-figure">
			<img alt="<?php echo $post_img_alt; ?>" title="<?php echo $post_img_title; ?>" src="<?php echo $optional_image_url; ?>" />
			<?php if( $post_img_title ) : ?>
				<figcaption class="text-center show-for-large-up">
					<?php echo $post_img_title; ?>
				</figcaption>
			<?php endif; ?>
		</figure>
	<?php
		}
		}
		echo '</div><!-- .hide-for-small, etc. -->';
	}
  ?>

	<?php if ( $meta && $meta['images'] ) : ?>
		<div class="medium-9 large-8 columns">
	<?php else : ?>
		<div class="large-12 columns">
	<?php endif; ?>
	<?php the_content(); ?>
	<div class="entry-meta">
		<?php if( is_singular() ) : ?>
			<hr />
			<?php wp_link_pages(); ?>
		<?php endif; ?>
		<?php pf_pagination(); ?>
		<?php if ( !is_page() ) : ?>
			<?php pf_categories() ?>
			<?php if( pf_show_tags() ) : ?>
				<?php pf_tags() ?>
			<?php endif; ?>
		<?php endif; ?>
	</div>

	</div><!-- .medium-9, etc. -->
	</div><!-- .entry-content -->

	<footer class="row">
		<div class="large-12 columns">
			<?php if ( pf_show_author() ) : ?>
				<?php echo pf_get_the_author( '', 'bio_w_posts'); ?>
			<?php endif; ?>
			<?php comments_template(); ?>
		</div>
	</footer>

</article><!-- #post -->



