<?php
/**
 * Template for used to display full content of an image post 
 *
 * @since Planet Foundation 1.0.0
 *
 * @package ncp\wp\themes\planet_foundation
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 */

 $phpdoc_hack=0;  // parser won't parse summary without some code
?>


<article id="post-<?php the_ID(); ?>" <?php post_class('pf-full-post'); ?>>

	<?php if( pf_show_title() ) : ?>
		<header class="entry-header row">
			<div class="large-12 columns">
				<?php if ( current_user_can( 'edit_posts' ) ) : ?>
					<h2 class="pf-edit-post entry-title"><?php the_title(); ?></h2>
				<?php else: ?>
					<h2 class="entry-title"><?php the_title(); ?></h2>
				<?php endif; ?>

				<div class="entry-meta pf-edit-post-link-container">
					<?php if ( !is_page() ) : ?>
						<?php edit_post_link( __( 'Edit Post', 'planet-foundation' ) ); ?>
					<?php else : ?>
						<?php edit_post_link( __( 'Edit Page', 'planet-foundation' ) ); ?>
					<?php endif; ?>
				</div>
				<hr />
			</div>
		</header><!-- .entry-header -->
	<?php endif; ?>


	<div class="entry-content">

		<div class="large-12 columns">
			<?php 
        /**
          * Adds flex video wrapper around video
          *
          * @param string $content
          *
          */
				function pf_add_flex_video($content) {
					$pattern = '~<iframe.*</iframe>|<embed.*</embed>~';
					preg_match_all($pattern, $content, $matches);
					foreach ($matches[0] as $match) {
						$wrappedframe = '<div class="flex-video">' . $match . '</div>';
						$content = str_replace($match, $wrappedframe, $content);
					}
					return $content;    
				}
				add_filter('the_content', 'pf_add_flex_video');
			?>
			<?php the_content(); ?>
			<?php remove_filter('the_content','pf_add_flex_video'); ?>
			<div class="entry-meta">
				<?php if( is_singular() ) : ?>
					<hr />
					<?php wp_link_pages(); ?>
				<?php endif; ?>

				<?php pf_categories() ?>
				<?php if( pf_show_tags() ) : ?>
					<?php pf_tags() ?>
				<?php endif; ?>
			</div>

		</div><!-- .large-12, etc. -->
	</div><!-- .entry-content -->

	<footer class="row">
		<div class="large-12 columns">
			<?php if ( pf_show_author() ) : ?>
				<?php echo pf_get_the_author( '', 'bio_w_posts'); ?>
			<?php endif; ?>
			<?php comments_template(); ?>
		</div>
	</footer>

</article><!-- #post -->



